/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.servicelocator;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.token.TokenRequestFilter;
import fi.csc.chipster.servicelocator.resource.Service;
import fi.csc.chipster.servicelocator.resource.ServiceCatalog;
import fi.csc.chipster.servicelocator.resource.ServiceResource;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class ServiceLocator {
    private Logger logger = LogManager.getLogger();
    private String serverId;
    private ServiceCatalog serviceCatalog;
    private AuthenticationClient authService;
    private Config config;
    private HttpServer httpServer;

    public ServiceLocator(Config config) {
        this.config = config;
    }

    public void startServer() throws IOException {
        String username = "service-locator";
        String password = this.config.getPassword(username);
        String authUri = this.config.getString("authentication-service");
        List<String> auths = Arrays.asList(authUri);
        this.authService = new AuthenticationClient(auths, username, password);
        this.serverId = RestUtils.createId();
        this.serviceCatalog = new ServiceCatalog();
        this.addService("authentication-service", this.config.getString("authentication-service"), this.config.getString("authentication-service-pub"));
        this.addService("file-broker", this.config.getString("file-broker"), this.config.getString("file-broker-pub"));
        this.addService("scheduler", this.config.getString("scheduler"), null);
        this.addService("session-db", this.config.getString("session-db"), this.config.getString("session-db-pub"));
        this.addService("session-db-events", this.config.getString("session-db-events"), this.config.getString("session-db-events-pub"));
        this.addService("toolbox", this.config.getString("toolbox-url"), this.config.getString("toolbox-url-pub"));
        this.addService("session-worker", this.config.getString("session-worker"), this.config.getString("session-worker-pub"));
        this.serviceCatalog.setReadOnly(true);
        TokenRequestFilter tokenRequestFilter = new TokenRequestFilter(this.authService);
        tokenRequestFilter.authenticationRequired(false);
        ResourceConfig rc = RestUtils.getDefaultResourceConfig().register((Object)new ServiceResource(this.serviceCatalog)).register((Object)tokenRequestFilter);
        URI baseUri = URI.create(this.config.getString("service-locator-bind"));
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)baseUri, (ResourceConfig)rc);
    }

    public void addService(String role, String uri, String publicUri) {
        Service service = new Service(role, uri, publicUri);
        this.serviceCatalog.add(role, service);
    }

    public static void main(String[] args) throws IOException {
        ServiceLocator server = new ServiceLocator(new Config());
        server.startServer();
        RestUtils.waitForShutdown("service locator", server.getHttpServer());
    }

    private HttpServer getHttpServer() {
        return this.httpServer;
    }

    public void close() {
        RestUtils.shutdown("service locator", this.httpServer);
    }
}

