/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.filebroker;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.CredentialsProvider;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestFileBrokerClient {
    private static final Logger logger = LogManager.getLogger();
    private ServiceLocatorClient serviceLocator;
    private List<String> fileBrokerList;
    private CredentialsProvider credentials;
    private WebTarget fileBrokerTarget;

    public RestFileBrokerClient(ServiceLocatorClient serviceLocator, CredentialsProvider credentials) {
        this.serviceLocator = serviceLocator;
        this.credentials = credentials;
        this.fileBrokerList = serviceLocator.get("file-broker");
        if (this.fileBrokerList.isEmpty()) {
            throw new InternalServerErrorException("no session-dbs registered to service-locator");
        }
        this.init(this.fileBrokerList.get(0));
    }

    public RestFileBrokerClient(String fileBrokerUri, CredentialsProvider credentials) {
        this.credentials = credentials;
        this.init(fileBrokerUri);
    }

    private void init(String sessionDbUri) {
        this.fileBrokerTarget = this.credentials != null ? AuthenticationClient.getClient(this.credentials.getUsername(), this.credentials.getPassword(), true).target(sessionDbUri) : AuthenticationClient.getClient().target(sessionDbUri);
    }

    private WebTarget getDatasetTarget(UUID sessionId, UUID datasetId) {
        return this.fileBrokerTarget.path("sessions").path(sessionId.toString()).path("datasets").path(datasetId.toString());
    }

    public void upload(UUID sessionId, UUID datasetId, File file) throws RestException, IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.upload(sessionId, datasetId, in);
        }
    }

    public void upload(UUID sessionId, UUID datasetId, InputStream inputStream) throws RestException {
        WebTarget target = this.getDatasetTarget(sessionId, datasetId);
        target.property("jersey.config.client.request.entity.processing", (Object)"CHUNKED");
        Response response = (Response)target.request().put(Entity.entity((Object)inputStream, (String)"application/octet-stream"), Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("upload failed ", response, target.getUri());
        }
    }

    public void download(UUID sessionId, UUID datasetId, File destFile) throws RestException, IOException {
        try (InputStream inStream = this.download(sessionId, datasetId);){
            Files.copy(inStream, destFile.toPath(), new CopyOption[0]);
        }
    }

    public InputStream download(UUID sessionId, UUID datasetId) throws RestException {
        WebTarget target = this.getDatasetTarget(sessionId, datasetId);
        Response response = (Response)target.request().get(Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("getting input stream failed", response, target.getUri());
        }
        return (InputStream)response.readEntity(InputStream.class);
    }
}

