/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.auth.resource;

import fi.csc.chipster.auth.model.Token;
import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.exception.NotAuthorizedException;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.hibernate.Transaction;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="tokens")
public class TokenResource {
    public static final String TOKENS = "tokens";
    private static final String TOKEN_HEADER = "chipster-token";
    private static Logger logger = LogManager.getLogger();
    private HibernateUtil hibernate;

    public TokenResource(HibernateUtil hibernate) {
        this.hibernate = hibernate;
    }

    @POST
    @RolesAllowed(value={"password"})
    @Produces(value={"application/json"})
    @Transaction
    public Response createToken(@Context SecurityContext sc) {
        this.cleanUp();
        AuthPrincipal principal = (AuthPrincipal)sc.getUserPrincipal();
        String username = sc.getUserPrincipal().getName();
        if (username == null) {
            throw new NotAuthorizedException("username is null");
        }
        Token token = this.createToken(username, principal.getRoles());
        this.getHibernate().session().save((Object)token);
        return Response.ok((Object)token).build();
    }

    public Token createToken(String username, HashSet<String> roles) {
        UUID tokenKey = RestUtils.createUUID();
        LocalDateTime valid = LocalDateTime.now().plusMonths(1L);
        String rolesJson = RestUtils.asJson(roles);
        return new Token(username, tokenKey, valid, rolesJson);
    }

    private void cleanUp() {
        int rows = this.getHibernate().session().createQuery("delete from Token where valid < :timestamp").setParameter("timestamp", (Object)LocalDateTime.now()).executeUpdate();
        if (rows > 0) {
            logger.info("deleted " + rows + " expired token(s)");
        }
    }

    @GET
    @RolesAllowed(value={"server"})
    @Produces(value={"application/json"})
    @Transaction
    public Response checkToken(@HeaderParam(value="chipster-token") String requestToken, @Context SecurityContext sc) {
        if (requestToken == null) {
            throw new NotFoundException("chipster-token header is null");
        }
        UUID uuid = this.parseUUID(requestToken);
        Token dbToken = (Token)this.getHibernate().session().get(Token.class, (Serializable)uuid);
        if (dbToken == null) {
            throw new NotFoundException("token not found");
        }
        if (dbToken.getValid().isAfter(LocalDateTime.now())) {
            return Response.ok((Object)dbToken).build();
        }
        throw new ForbiddenException("token expired");
    }

    private UUID parseUUID(String token) {
        try {
            return UUID.fromString(token);
        }
        catch (IllegalArgumentException e) {
            throw new NotAuthorizedException("token is not a valid UUID");
        }
    }

    @DELETE
    @RolesAllowed(value={"client"})
    @Transaction
    public Response delete(@Context SecurityContext sc) {
        AuthPrincipal principal = (AuthPrincipal)sc.getUserPrincipal();
        UUID uuid = this.parseUUID(principal.getTokenKey());
        Token dbToken = (Token)this.getHibernate().session().get(Token.class, (Serializable)uuid);
        if (dbToken == null) {
            throw new NotFoundException();
        }
        this.getHibernate().session().delete((Object)dbToken);
        return Response.noContent().build();
    }

    private HibernateUtil getHibernate() {
        return this.hibernate;
    }
}

