package org.jfree.chart.entity.junit;

import java.awt.geom.Area;
import java.awt.Shape;
import java.lang.Integer;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.HeatMapBlockEntity;


/**
 * Tests for the {@link org.jfree.chart.entity.HeatMapBlockEntity} class.
 */
public class HeatMapBlockEntityTests extends TestCase {


    /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(HeatMapBlockEntityTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public HeatMapBlockEntityTests(String name) {
        super(name);
    }


   /**
    * Does the tests.
    */ 
   public void testEntity(){

	// first test with correct values.
	HeatMapBlockEntity entity = new HeatMapBlockEntity(new Area(), "tooltip", "url", 1, 2);

	assertEquals(entity.getRow(), 1);
	assertEquals(entity.getColumn(), 2);

	// now try some weird ones
	// null Area object
	try {
	  entity = new HeatMapBlockEntity(null, "tooltip", "url", 1, 2);
	  assertTrue(false);
	} catch (Exception e){;}
	
	// null String-values, integer max and min
	try {
	  entity = new HeatMapBlockEntity(new Area(), null, null, 
						Integer.MAX_VALUE,
						Integer.MIN_VALUE
						);
	  assertTrue(true);
	} catch (Exception e){;}
	

   }
}
