/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.text.NumberFormat;

public class ScaleUtil {
    private static NumberFormat numberFormat = NumberFormat.getInstance();
    public static final int DEFAULT_STEP_COUNT = 4;

    public static String format(float f) {
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format(f);
    }

    public static float[] generateScaleValues(float min, float max) {
        return ScaleUtil.generateScaleValues(min, max, 4);
    }

    public static float[] generateScaleValues(float min, float max, int stepCount) {
        float[] scaleMinMax = ScaleUtil.getStepDistance(min, max, stepCount);
        if (scaleMinMax[0] == scaleMinMax[1]) {
            scaleMinMax[1] = scaleMinMax[1] + 1.0f;
        }
        float scaleMin = scaleMinMax[0];
        float scaleMax = scaleMinMax[1];
        if (scaleMin < 0.0f && scaleMax > 0.0f && stepCount == 4) {
            if (Math.abs(min) > max) {
                if (Math.abs(scaleMin) > scaleMax * 2.0f) {
                    scaleMax = Math.abs(scaleMin / 2.0f);
                } else {
                    scaleMin = -scaleMax * 2.0f;
                }
            } else if (Math.abs(scaleMin) * 2.0f > scaleMax) {
                scaleMax = Math.abs(scaleMin * 2.0f);
            } else {
                scaleMin = -scaleMax / 2.0f;
            }
        }
        float[] values = new float[stepCount];
        for (int i = 0; i < stepCount; ++i) {
            values[i] = scaleMin + (scaleMax - scaleMin) / (float)(stepCount - 1) * (float)i;
        }
        return values;
    }

    private static float[] getStepDistance(float minValue, float maxValue, int stepCount) {
        float preferredScale = Math.abs(maxValue - minValue) / (float)stepCount;
        float decimalFactor = ScaleUtil.calculateDecimalFactor(preferredScale);
        float scaleMax = (float)Math.ceil(maxValue / decimalFactor) * decimalFactor;
        float scaleMin = (float)Math.floor(minValue / decimalFactor) * decimalFactor;
        return new float[]{scaleMin, scaleMax};
    }

    private static float calculateDecimalFactor(float preferredScale) {
        float decimalFactor = 1.0f;
        if (preferredScale >= 10.0f) {
            while (preferredScale >= decimalFactor * 10.0f) {
                decimalFactor *= 10.0f;
            }
        } else {
            while (preferredScale < decimalFactor / 10.0f) {
                decimalFactor /= 10.0f;
            }
        }
        return decimalFactor;
    }
}

