/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.amq;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.command.JournalTopicAck;
import org.apache.activemq.command.JournalTransaction;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.store.TransactionRecoveryListener;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.amq.AMQMessageStore;
import org.apache.activemq.store.amq.AMQPersistenceAdapter;
import org.apache.activemq.store.amq.AMQTopicMessageStore;
import org.apache.activemq.store.amq.AMQTx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQTransactionStore
implements TransactionStore {
    protected Map<TransactionId, AMQTx> inflightTransactions = new LinkedHashMap<TransactionId, AMQTx>();
    Map<TransactionId, AMQTx> preparedTransactions = new LinkedHashMap<TransactionId, AMQTx>();
    private final AMQPersistenceAdapter peristenceAdapter;
    private boolean doingRecover;

    public AMQTransactionStore(AMQPersistenceAdapter adapter) {
        this.peristenceAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(TransactionId txid) throws IOException {
        AMQTx tx = null;
        Map<TransactionId, AMQTx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.remove(txid);
        }
        if (tx == null) {
            return;
        }
        this.peristenceAdapter.writeCommand(new JournalTransaction(1, txid, false), true);
        map = this.preparedTransactions;
        synchronized (map) {
            this.preparedTransactions.put(txid, tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayPrepare(TransactionId txid) throws IOException {
        AMQTx tx = null;
        Map<TransactionId, AMQTx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.remove(txid);
        }
        if (tx == null) {
            return;
        }
        map = this.preparedTransactions;
        synchronized (map) {
            this.preparedTransactions.put(txid, tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQTx getTx(TransactionId txid, Location location) {
        AMQTx tx = null;
        Map<TransactionId, AMQTx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.get(txid);
            if (tx == null) {
                tx = new AMQTx(location);
                this.inflightTransactions.put(txid, tx);
            }
        }
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(TransactionId txid, boolean wasPrepared, Runnable preCommit, Runnable postCommit) throws IOException {
        AMQTx tx;
        if (preCommit != null) {
            preCommit.run();
        }
        if (wasPrepared) {
            Map<TransactionId, AMQTx> map = this.preparedTransactions;
            synchronized (map) {
                tx = this.preparedTransactions.remove(txid);
            }
        }
        Map<TransactionId, AMQTx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.remove(txid);
        }
        if (tx == null) {
            if (postCommit != null) {
                postCommit.run();
            }
            return;
        }
        if (txid.isXATransaction()) {
            this.peristenceAdapter.writeCommand(new JournalTransaction(2, txid, wasPrepared), true, true);
        } else {
            this.peristenceAdapter.writeCommand(new JournalTransaction(4, txid, wasPrepared), true, true);
        }
        if (postCommit != null) {
            postCommit.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQTx replayCommit(TransactionId txid, boolean wasPrepared) throws IOException {
        if (wasPrepared) {
            Map<TransactionId, AMQTx> map = this.preparedTransactions;
            synchronized (map) {
                return this.preparedTransactions.remove(txid);
            }
        }
        Map<TransactionId, AMQTx> map = this.inflightTransactions;
        synchronized (map) {
            return this.inflightTransactions.remove(txid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(TransactionId txid) throws IOException {
        AMQTx tx = null;
        Map<TransactionId, AMQTx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.remove(txid);
        }
        if (tx != null) {
            map = this.preparedTransactions;
            synchronized (map) {
                tx = this.preparedTransactions.remove(txid);
            }
        }
        if (tx != null) {
            if (txid.isXATransaction()) {
                this.peristenceAdapter.writeCommand(new JournalTransaction(3, txid, false), true, true);
            } else {
                this.peristenceAdapter.writeCommand(new JournalTransaction(5, txid, false), true, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayRollback(TransactionId txid) throws IOException {
        boolean inflight = false;
        Map<TransactionId, AMQTx> map = this.inflightTransactions;
        synchronized (map) {
            inflight = this.inflightTransactions.remove(txid) != null;
        }
        if (inflight) {
            map = this.preparedTransactions;
            synchronized (map) {
                this.preparedTransactions.remove(txid);
            }
        }
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void recover(TransactionRecoveryListener listener) throws IOException {
        Map<TransactionId, AMQTx> map = this.inflightTransactions;
        synchronized (map) {
            this.inflightTransactions.clear();
        }
        this.doingRecover = true;
        try {
            LinkedHashMap<TransactionId, AMQTx> txs = null;
            Map<TransactionId, AMQTx> map2 = this.preparedTransactions;
            synchronized (map2) {
                txs = new LinkedHashMap<TransactionId, AMQTx>(this.preparedTransactions);
            }
            for (Object txid : txs.keySet()) {
                AMQTx tx = (AMQTx)txs.get(txid);
                listener.recover((XATransactionId)txid, tx.getMessages(), tx.getAcks());
            }
        }
        finally {
            this.doingRecover = false;
        }
    }

    void addMessage(AMQMessageStore store, Message message, Location location) throws IOException {
        AMQTx tx = this.getTx(message.getTransactionId(), location);
        tx.add(store, message, location);
    }

    public void removeMessage(AMQMessageStore store, MessageAck ack, Location location) throws IOException {
        AMQTx tx = this.getTx(ack.getTransactionId(), location);
        tx.add(store, ack);
    }

    public void acknowledge(AMQTopicMessageStore store, JournalTopicAck ack, Location location) {
        AMQTx tx = this.getTx(ack.getTransactionId(), location);
        tx.add(store, ack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location checkpoint() throws IOException {
        Location location;
        Location minimumLocationInUse = null;
        Map<TransactionId, AMQTx> map = this.inflightTransactions;
        synchronized (map) {
            for (AMQTx tx : this.inflightTransactions.values()) {
                location = tx.getLocation();
                if (minimumLocationInUse != null && location.compareTo(minimumLocationInUse) >= 0) continue;
                minimumLocationInUse = location;
            }
        }
        map = this.preparedTransactions;
        synchronized (map) {
            for (AMQTx tx : this.preparedTransactions.values()) {
                location = tx.getLocation();
                if (minimumLocationInUse != null && location.compareTo(minimumLocationInUse) >= 0) continue;
                minimumLocationInUse = location;
            }
            return minimumLocationInUse;
        }
    }

    public boolean isDoingRecover() {
        return this.doingRecover;
    }

    public Map<TransactionId, AMQTx> getPreparedTransactions() {
        return this.preparedTransactions;
    }

    public void setPreparedTransactions(Map<TransactionId, AMQTx> preparedTransactions) {
        if (preparedTransactions != null) {
            this.preparedTransactions.clear();
            this.preparedTransactions.putAll(preparedTransactions);
        }
    }
}

