/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jndi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.apache.camel.spi.Injector;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiContext
implements Context,
Serializable {
    public static final String SEPARATOR = "/";
    protected static final NameParser NAME_PARSER = new NameParser(){

        public Name parse(String name) throws NamingException {
            return new CompositeName(name);
        }
    };
    protected static final Injector INJETOR = new ReflectionInjector();
    private static final long serialVersionUID = -5754338187296859149L;
    private final Hashtable<String, Object> environment;
    private final Map<String, Object> bindings;
    private final Map<String, Object> treeBindings;
    private boolean frozen;
    private String nameInNamespace = "";

    public JndiContext() throws Exception {
        this(new Hashtable<String, Object>());
    }

    public JndiContext(Hashtable<String, Object> env) throws Exception {
        this(env, JndiContext.createBindingsMapFromEnvironment(env));
    }

    public JndiContext(Hashtable<String, Object> environment, Map<String, Object> bindings) {
        this.environment = environment == null ? new Hashtable() : new Hashtable<String, Object>(environment);
        this.bindings = bindings;
        this.treeBindings = new HashMap<String, Object>();
    }

    public JndiContext(Hashtable<String, Object> environment, Map<String, Object> bindings, String nameInNamespace) {
        this(environment, bindings);
        this.nameInNamespace = nameInNamespace;
    }

    protected JndiContext(JndiContext clone, Hashtable<String, Object> env) {
        this.bindings = clone.bindings;
        this.treeBindings = clone.treeBindings;
        this.environment = new Hashtable<String, Object>(env);
    }

    protected JndiContext(JndiContext clone, Hashtable<String, Object> env, String nameInNamespace) {
        this(clone, env);
        this.nameInNamespace = nameInNamespace;
    }

    public static Map<String, Object> createBindingsMapFromEnvironment(Hashtable<String, Object> env) throws Exception {
        HashMap<String, Object> answer = new HashMap<String, Object>(env);
        for (Map.Entry<String, Object> entry : env.entrySet()) {
            String newEntry;
            Object bean;
            Class<?> type;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || !(value instanceof String)) continue;
            String valueText = (String)value;
            if (!key.endsWith(".class") || (type = ObjectHelper.loadClass(valueText)) == null || (bean = JndiContext.createBean(type, answer, (newEntry = key.substring(0, key.length() - ".class".length())) + ".")) == null) continue;
            answer.put(newEntry, bean);
        }
        return answer;
    }

    public void freeze() {
        this.frozen = true;
    }

    boolean isFrozen() {
        return this.frozen;
    }

    protected Map<String, Object> internalBind(String name, Object value) throws NamingException {
        assert (name != null && name.length() > 0);
        assert (!this.frozen);
        HashMap<String, Object> newBindings = new HashMap<String, Object>();
        int pos = name.indexOf(47);
        if (pos == -1) {
            if (this.treeBindings.put(name, value) != null) {
                throw new NamingException("Something already bound at " + name);
            }
            this.bindings.put(name, value);
            newBindings.put(name, value);
        } else {
            String segment = name.substring(0, pos);
            assert (segment != null);
            assert (!segment.equals(""));
            Object o = this.treeBindings.get(segment);
            if (o == null) {
                o = this.newContext();
                this.treeBindings.put(segment, o);
                this.bindings.put(segment, o);
                newBindings.put(segment, o);
            } else if (!(o instanceof JndiContext)) {
                throw new NamingException("Something already bound where a subcontext should go");
            }
            JndiContext defaultContext = (JndiContext)o;
            String remainder = name.substring(pos + 1);
            Map<String, Object> subBindings = defaultContext.internalBind(remainder, value);
            for (Map.Entry<String, Object> entry : subBindings.entrySet()) {
                String subName = segment + SEPARATOR + entry.getKey();
                Object bound = entry.getValue();
                this.treeBindings.put(subName, bound);
                newBindings.put(subName, bound);
            }
        }
        return newBindings;
    }

    protected JndiContext newContext() {
        try {
            return new JndiContext();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.environment.put(propName, propVal);
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        return CastUtils.cast((Hashtable)this.environment.clone(), String.class, Object.class);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (name.length() == 0) {
            return this;
        }
        Object result = this.treeBindings.get(name);
        if (result == null) {
            result = this.bindings.get(name);
        }
        if (result == null) {
            int pos = name.indexOf(58);
            if (pos > 0) {
                String scheme = name.substring(0, pos);
                Context ctx = NamingManager.getURLContext(scheme, this.environment);
                if (ctx == null) {
                    throw new NamingException("scheme " + scheme + " not recognized");
                }
                return ctx.lookup(name);
            }
            CompositeName path = new CompositeName(name);
            if (path.size() == 0) {
                return this;
            }
            String first = path.get(0);
            Object value = this.bindings.get(first);
            if (value == null) {
                throw new NameNotFoundException(name);
            }
            if (value instanceof Context && path.size() > 1) {
                Context subContext = (Context)value;
                value = subContext.lookup(path.getSuffix(1));
            }
            return value;
        }
        if (result instanceof LinkRef) {
            LinkRef ref = (LinkRef)result;
            result = this.lookup(ref.getLinkName());
        }
        if (result instanceof Reference) {
            try {
                result = NamingManager.getObjectInstance(result, null, null, this.environment);
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                throw (NamingException)new NamingException("could not look up : " + name).initCause(e);
            }
        }
        if (result instanceof JndiContext) {
            String prefix = this.getNameInNamespace();
            if (prefix.length() > 0) {
                prefix = prefix + SEPARATOR;
            }
            result = new JndiContext((JndiContext)result, this.environment, prefix + name);
        }
        return result;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        CompositeName result = new CompositeName(prefix);
        result.addAll(new CompositeName(name));
        return result.toString();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        Object o = this.lookup(name);
        if (o == this) {
            return CastUtils.cast(new ListEnumeration());
        }
        if (o instanceof Context) {
            return ((Context)o).list("");
        }
        throw new NotContextException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        Object o = this.lookup(name);
        if (o == this) {
            return CastUtils.cast(new ListBindingEnumeration());
        }
        if (o instanceof Context) {
            return ((Context)o).listBindings("");
        }
        throw new NotContextException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public void bind(Name name, Object value) throws NamingException {
        this.bind(name.toString(), value);
    }

    @Override
    public void bind(String name, Object value) throws NamingException {
        if (this.isFrozen()) {
            throw new OperationNotSupportedException();
        }
        this.internalBind(name, value);
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.nameInNamespace;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return NAME_PARSER;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return NAME_PARSER;
    }

    @Override
    public void rebind(Name name, Object value) throws NamingException {
        this.bind(name, value);
    }

    @Override
    public void rebind(String name, Object value) throws NamingException {
        this.bind(name, value);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.bindings.remove(name);
        this.treeBindings.remove(name);
    }

    protected static Object createBean(Class<?> type, Map<String, Object> properties, String prefix) throws Exception {
        Object value = INJETOR.newInstance(type);
        IntrospectionSupport.setProperties(value, properties, prefix);
        return value;
    }

    private class ListBindingEnumeration
    extends LocalNamingEnumeration {
        ListBindingEnumeration() {
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            Map.Entry<String, Object> entry = this.getNext();
            return new Binding(entry.getKey(), entry.getValue());
        }
    }

    private class ListEnumeration
    extends LocalNamingEnumeration {
        ListEnumeration() {
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            Map.Entry<String, Object> entry = this.getNext();
            return new NameClassPair(entry.getKey(), entry.getValue().getClass().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class LocalNamingEnumeration
    implements NamingEnumeration<Object> {
        private Iterator<Map.Entry<String, Object>> i;

        private LocalNamingEnumeration() {
            this.i = JndiContext.this.bindings.entrySet().iterator();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.i.hasNext();
        }

        @Override
        public boolean hasMoreElements() {
            return this.i.hasNext();
        }

        protected Map.Entry<String, Object> getNext() {
            return this.i.next();
        }

        @Override
        public void close() throws NamingException {
        }
    }
}

