/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntrospectionSupport {
    private static final transient Log LOG = LogFactory.getLog(IntrospectionSupport.class);
    private static final Pattern GETTER_PATTERN = Pattern.compile("(get|is)[A-Z].*");
    private static final Pattern SETTER_PATTERN = Pattern.compile("set[A-Z].*");
    private static final List<Method> EXCLUDED_METHODS = new ArrayList<Method>();

    private IntrospectionSupport() {
    }

    public static boolean isGetter(Method method) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        if (!GETTER_PATTERN.matcher(name).matches()) {
            return false;
        }
        if (name.startsWith("is")) {
            return params.length == 0 && type.getSimpleName().equalsIgnoreCase("boolean");
        }
        return params.length == 0 && !type.equals(Void.TYPE);
    }

    public static String getGetterShorthandName(Method method) {
        if (!IntrospectionSupport.isGetter(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.substring(3);
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }

    public static String getSetterShorthandName(Method method) {
        if (!IntrospectionSupport.isSetter(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith("set")) {
            name = name.substring(3);
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }

    public static boolean isSetter(Method method) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        if (!SETTER_PATTERN.matcher(name).matches()) {
            return false;
        }
        return params.length == 1 && type.equals(Void.TYPE);
    }

    public static boolean getProperties(Object target, Map properties, String optionPrefix) {
        Method[] methods;
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(properties, "properties");
        boolean rc = false;
        if (optionPrefix == null) {
            optionPrefix = "";
        }
        Class<?> clazz = target.getClass();
        for (Method method : methods = clazz.getMethods()) {
            if (EXCLUDED_METHODS.contains(method)) continue;
            try {
                if (!IntrospectionSupport.isGetter(method) || !IntrospectionSupport.hasSetter(target, method)) continue;
                Object value = method.invoke(target, new Object[0]);
                String name = IntrospectionSupport.getGetterShorthandName(method);
                properties.put(optionPrefix + name, value);
                rc = true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return rc;
    }

    public static boolean hasSetter(Object target, Method getter) {
        Method[] methods;
        String name = IntrospectionSupport.getGetterShorthandName(getter);
        Class<?> clazz = target.getClass();
        for (Method method : methods = clazz.getMethods()) {
            if (EXCLUDED_METHODS.contains(method) || !IntrospectionSupport.isSetter(method) || !name.equals(IntrospectionSupport.getSetterShorthandName(method))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasProperties(Map<String, Object> properties, String optionPrefix) {
        ObjectHelper.notNull(properties, "properties");
        if (ObjectHelper.isNotEmpty(optionPrefix)) {
            for (String o : properties.keySet()) {
                String name = o;
                if (!name.startsWith(optionPrefix)) continue;
                return true;
            }
            return false;
        }
        return !properties.isEmpty();
    }

    public static Object getProperty(Object target, String property) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(property, "property");
        property = property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1);
        Class<?> clazz = target.getClass();
        Method method = IntrospectionSupport.getPropertyGetter(clazz, property);
        return method.invoke(target, new Object[0]);
    }

    public static Method getPropertyGetter(Class<?> type, String propertyName) throws NoSuchMethodException {
        if (IntrospectionSupport.isPropertyIsGetter(type, propertyName)) {
            return type.getMethod("is" + ObjectHelper.capitalize(propertyName), new Class[0]);
        }
        return type.getMethod("get" + ObjectHelper.capitalize(propertyName), new Class[0]);
    }

    public static boolean isPropertyIsGetter(Class<?> type, String propertyName) {
        try {
            Method method = type.getMethod("is" + ObjectHelper.capitalize(propertyName), new Class[0]);
            if (method != null) {
                return method.getReturnType().isAssignableFrom(Boolean.TYPE) || method.getReturnType().isAssignableFrom(Boolean.class);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public static boolean setProperties(Object target, Map<String, Object> properties, String optionPrefix) throws Exception {
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(properties, "properties");
        boolean rc = false;
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey().toString();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties.get(name);
            if (!IntrospectionSupport.setProperty(target, name = name.substring(optionPrefix.length()), value)) continue;
            it.remove();
            rc = true;
        }
        return rc;
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties, String optionPrefix) {
        ObjectHelper.notNull(properties, "properties");
        LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>(properties.size());
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            it.remove();
        }
        return rc;
    }

    public static boolean setProperties(TypeConverter typeConverter, Object target, Map<String, Object> properties) throws Exception {
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(properties, "properties");
        boolean rc = false;
        Iterator<Map.Entry<String, Object>> iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            if (!IntrospectionSupport.setProperty(typeConverter, target, entry.getKey(), entry.getValue())) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static boolean setProperties(Object target, Map<String, Object> properties) throws Exception {
        return IntrospectionSupport.setProperties(null, target, properties);
    }

    public static boolean setProperty(TypeConverter typeConverter, Object target, String name, Object value) throws Exception {
        try {
            Class<?> clazz = target.getClass();
            Set<Method> setters = IntrospectionSupport.findSetterMethods(typeConverter, clazz, name, value);
            if (setters.isEmpty()) {
                return false;
            }
            Exception typeConvertionFailed = null;
            for (Method setter : setters) {
                if (value == null || setter.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                    setter.invoke(target, value);
                    return true;
                }
                try {
                    Object convertedValue = IntrospectionSupport.convert(typeConverter, setter.getParameterTypes()[0], value);
                    setter.invoke(target, convertedValue);
                    return true;
                }
                catch (NoTypeConversionAvailableException e) {
                    typeConvertionFailed = e;
                }
                catch (IllegalArgumentException e) {
                    typeConvertionFailed = e;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Setter \"" + setter + "\" with parameter type \"" + setter.getParameterTypes()[0] + "\" could not be used for type conversions of " + value));
            }
            if (typeConvertionFailed != null) {
                throw new IllegalArgumentException("Could not find a suitable setter for property: " + name + " as there isn't a setter method with same type: " + value.getClass().getCanonicalName() + " nor type conversion possible: " + typeConvertionFailed.getMessage());
            }
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                throw exception;
            }
            Error error = (Error)throwable;
            throw error;
        }
    }

    public static boolean setProperty(Object target, String name, Object value) throws Exception {
        return IntrospectionSupport.setProperty(null, target, name, value);
    }

    private static Object convert(TypeConverter typeConverter, Class type, Object value) throws URISyntaxException, NoTypeConversionAvailableException {
        if (typeConverter != null) {
            return typeConverter.mandatoryConvertTo(type, value);
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setAsText(value.toString());
            return editor.getValue();
        }
        if (type == URI.class) {
            return new URI(value.toString());
        }
        return null;
    }

    private static Set<Method> findSetterMethods(TypeConverter typeConverter, Class<?> clazz, String name, Object value) {
        LinkedHashSet<Method> candidates = new LinkedHashSet<Method>();
        name = "set" + ObjectHelper.capitalize(name);
        while (clazz != Object.class) {
            Method[] methods;
            Method objectSetMethod = null;
            for (Method method : methods = clazz.getMethods()) {
                Class<?>[] params = method.getParameterTypes();
                if (!method.getName().equals(name) || params.length != 1) continue;
                Class<?> paramType = params[0];
                if (paramType.equals(Object.class)) {
                    objectSetMethod = method;
                    continue;
                }
                if (typeConverter == null && !IntrospectionSupport.isSetter(method) && !paramType.isInstance(value)) continue;
                candidates.add(method);
            }
            if (objectSetMethod != null) {
                candidates.add(objectSetMethod);
            }
            clazz = clazz.getSuperclass();
        }
        if (candidates.isEmpty()) {
            return candidates;
        }
        if (candidates.size() == 1) {
            return candidates;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Found " + candidates.size() + " suitable setter methods for setting " + name));
        }
        for (Method method : candidates) {
            if (!method.getParameterTypes()[0].isInstance(value)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Method " + method + " is the best candidate as it has parameter with same instance type"));
            }
            candidates.clear();
            candidates.add(method);
            return candidates;
        }
        return candidates;
    }

    static {
        EXCLUDED_METHODS.addAll(Arrays.asList(Object.class.getMethods()));
        EXCLUDED_METHODS.addAll(Arrays.asList(Proxy.class.getMethods()));
    }
}

