/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.LogProcessor;
import org.apache.camel.processor.Logger;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="log")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LogDefinition
extends ProcessorDefinition {
    @XmlAttribute
    private String message;
    @XmlAttribute
    private LoggingLevel loggingLevel = LoggingLevel.INFO;
    @XmlAttribute
    private String logName;

    public LogDefinition() {
    }

    public LogDefinition(String message) {
        this.message = message;
    }

    public String toString() {
        return "Log[" + this.message + "]";
    }

    @Override
    public String getShortName() {
        return "log";
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notEmpty(this.message, "message", this);
        Expression exp = routeContext.getCamelContext().resolveLanguage("simple").createExpression(this.message);
        String name = this.getLogName();
        if (name == null) {
            name = routeContext.getRoute().getId();
        }
        Logger logger = new Logger(name, this.getLoggingLevel());
        return new LogProcessor(exp, logger);
    }

    @Override
    public void addOutput(ProcessorDefinition output) {
        this.getParent().addOutput(output);
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }
}

