/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.impl.PollingConsumerSupport;
import org.apache.camel.util.ServiceHelper;

public class ProcessorPollingConsumer
extends PollingConsumerSupport {
    private final Processor processor;

    public ProcessorPollingConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint);
        this.processor = processor;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService(this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processor);
    }

    public Exchange receive() {
        Exchange exchange = this.getEndpoint().createExchange();
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Error while processing exchange", exchange, e);
        }
        return exchange;
    }

    public Exchange receiveNoWait() {
        return this.receive();
    }

    public Exchange receive(long timeout) {
        return this.receive();
    }
}

