/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.graphics;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.emboss.jemboss.graphics.Graph2DPlot;
import org.emboss.jemboss.gui.ScrollPanel;

public class PrintPlot
extends ScrollPanel {
    private Graph2DPlot plot;

    public PrintPlot(Graph2DPlot graph2DPlot) {
        this.plot = graph2DPlot;
    }

    public void print() {
        String string = System.getProperty("user.dir");
        JFileChooser jFileChooser = new JFileChooser(string);
        File file = new File(string + System.getProperty("file.separator") + "jemboss.png");
        jFileChooser.setSelectedFile(file);
        Box box = Box.createVerticalBox();
        JLabel jLabel = new JLabel("Select Format:");
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(1));
        box.add(jLabel);
        Box box2 = Box.createHorizontalBox();
        JComboBox<String> jComboBox = new JComboBox<String>(ImageIO.getWriterFormatNames());
        jComboBox.setSelectedItem("png");
        Dimension dimension = jComboBox.getPreferredSize();
        jComboBox.setMaximumSize(dimension);
        box2.add(Box.createHorizontalGlue());
        box2.add(jComboBox);
        box.add(box2);
        jFileChooser.setAccessory(box);
        int n = jFileChooser.showSaveDialog(null);
        if (n == 1) {
            return;
        }
        String string2 = jFileChooser.getSelectedFile().getAbsolutePath().toLowerCase();
        if (string2.endsWith(".png") || string2.endsWith(".jpg") || string2.endsWith(".jpeg")) {
            int n2 = string2.lastIndexOf(".");
            string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            string2 = string2.substring(0, n2);
        } else {
            string2 = jFileChooser.getSelectedFile().getAbsolutePath();
        }
        String string3 = (String)jComboBox.getSelectedItem();
        try {
            RenderedImage renderedImage = this.createImage();
            this.writeImageToFile(renderedImage, new File(string2 + "." + string3), string3);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            JOptionPane.showMessageDialog(this, "This option requires Java 1.4 or higher.");
        }
    }

    private RenderedImage createImage() {
        BufferedImage bufferedImage = new BufferedImage(this.plot.getWidth(), this.plot.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.plot.printComponent(graphics2D);
        return bufferedImage;
    }

    private void writeImageToFile(RenderedImage renderedImage, File file, String string) {
        try {
            ImageIO.write(renderedImage, string, file);
        }
        catch (IOException iOException) {
            System.out.println("Java 1.4+ is required");
            iOException.printStackTrace();
        }
    }
}

