/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.module.chipster;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.QuickLinkPanel;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.dialog.TaskImportDialog;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.selection.IntegratedEntity;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationUtilities;
import fi.csc.microarray.client.visualisation.methods.ArrayLayout;
import fi.csc.microarray.client.visualisation.methods.ChipsterGBrowserVisualisation;
import fi.csc.microarray.client.visualisation.methods.ClusteredProfiles;
import fi.csc.microarray.client.visualisation.methods.ExpressionProfile;
import fi.csc.microarray.client.visualisation.methods.Heatmap;
import fi.csc.microarray.client.visualisation.methods.HierarchicalClustering;
import fi.csc.microarray.client.visualisation.methods.Histogram;
import fi.csc.microarray.client.visualisation.methods.PhenodataEditor;
import fi.csc.microarray.client.visualisation.methods.SOM;
import fi.csc.microarray.client.visualisation.methods.SamBamViewer;
import fi.csc.microarray.client.visualisation.methods.Scatterplot;
import fi.csc.microarray.client.visualisation.methods.Scatterplot3DPCA;
import fi.csc.microarray.client.visualisation.methods.VennDiagram;
import fi.csc.microarray.client.visualisation.methods.Volcanoplot;
import fi.csc.microarray.client.visualisation.methods.threed.Scatterplot3D;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.TypeTag;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.databeans.features.bio.EmbeddedBinaryProvider;
import fi.csc.microarray.databeans.features.bio.IdentifierProvider;
import fi.csc.microarray.databeans.features.bio.NormalisedExpressionProvider;
import fi.csc.microarray.databeans.features.stat.HierarchicalClusterProvider;
import fi.csc.microarray.databeans.features.stat.SomClusterProvider;
import fi.csc.microarray.databeans.features.table.EditableTable;
import fi.csc.microarray.databeans.features.table.TableBeanEditor;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.module.basic.BasicModule;
import fi.csc.microarray.util.LinkUtil;
import fi.csc.microarray.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXHyperlink;

public class MicroarrayModule
implements Module {
    private static final String EXAMPLE_SESSION_URL_ARRAY = "http://chipster.csc.fi/examples/chipster2-example-microarray.zip";
    private static final String EXAMPLE_SESSION_URL_NGS = "http://chipster.csc.fi/examples/chipster2-example.zip";
    private static final String STANDALONE_EXAMPLE_SESSION_URL = "http://chipster.csc.fi/examples/viewer-example-session.zip";
    public static final String SERVER_MODULE_NAME = "microarray";
    public static final String ANNOTATION_ID = "annotate-genelist2html.R";
    public static final String IMPORT_FROM_ARRAYEXPRESS_ID = "import-ArrayExpress.R";
    public static final String IMPORT_FROM_GEO_ID = "import-soft2.R";

    @Override
    public void plugContentTypes(DataManager manager) {
        manager.plugContentType("application/x-treeview", true, false, "Newick formatted tree from clustering", VisualConstants.ICON_TYPE_TEXT, "tre");
        manager.plugContentType("application/cel", true, false, "Affymetrix CEL", VisualConstants.ICON_TYPE_RAWDATA, "cel");
        manager.plugContentType("text/bed", true, false, "BED file", VisualConstants.ICON_TYPE_TEXT, "bed");
        manager.plugContentType("text/gtf", true, false, "Gene Transfer Format file", VisualConstants.ICON_TYPE_TEXT, "gtf", "gff", "gff2", "gff3");
        manager.plugContentType("chemical/x-fasta", true, false, "FASTA", VisualConstants.ICON_TYPE_TEXT, "fasta", "fa", "fna", "fsa", "mpfa");
        manager.plugContentType("text/fastq", true, false, "FASTQ", VisualConstants.ICON_TYPE_TEXT, "fastq", "fq");
        manager.plugContentType("application/gzip", true, true, "Gzip file", VisualConstants.ICON_TYPE_BINARY, "gz");
        manager.plugContentType("text/vcf", true, false, "Variant Call Format", VisualConstants.ICON_TYPE_TEXT, "vcf");
        manager.plugContentType("application/bam", true, false, "Binary sequence Alignment/Map format", VisualConstants.ICON_TYPE_TEXT, "bam");
        manager.plugContentType("text/qual", true, false, "Quality file", VisualConstants.ICON_TYPE_TEXT, "qual");
        manager.plugContentType("text/mothur-oligos", true, false, "Mothur oligos file", VisualConstants.ICON_TYPE_TEXT, "oligos");
        manager.plugContentType("text/mothur-names", true, false, "Mothur names file", VisualConstants.ICON_TYPE_TEXT, "names");
        manager.plugContentType("text/mothur-groups", true, false, "Mothur groups file", VisualConstants.ICON_TYPE_TEXT, "groups");
        manager.plugContentType("text/sff", true, false, "sff file", VisualConstants.ICON_TYPE_TEXT, "sff");
    }

    @Override
    public void plugFeatures(DataManager manager) {
        manager.plugFeatureFactory("/normalised-expression", new NormalisedExpressionProvider());
        manager.plugFeatureFactory("/identifier", new IdentifierProvider());
        manager.plugFeatureFactory("/embedded-binary-content", new EmbeddedBinaryProvider());
        manager.plugFeatureFactory("/clusters/som", new SomClusterProvider());
        manager.plugFeatureFactory("/clusters/hierarchical", new HierarchicalClusterProvider());
    }

    @Override
    public void plugModifiers(DataManager manager) {
    }

    @Override
    public void plugTypeTags(DataManager manager) {
    }

    @Override
    public String[] getServerModuleNames() {
        return new String[]{SERVER_MODULE_NAME, "ngs"};
    }

    @Override
    public String getModuleLongName(String moduleName) {
        if (SERVER_MODULE_NAME.equals(moduleName)) {
            return "Microarrays";
        }
        if ("ngs".equals(moduleName)) {
            return "NGS";
        }
        if ("misc".equals(moduleName)) {
            return "Misc";
        }
        return moduleName;
    }

    @Override
    public void addImportMenuItems(JMenu importMenu) {
        importMenu.add(this.getImportFromArrayExpressMenuItem());
        importMenu.add(this.getImportFromGEOMenuItem());
        importMenu.addSeparator();
    }

    private JMenuItem getImportFromArrayExpressMenuItem() {
        JMenuItem importFromArrayExpressMenuItem = new JMenuItem();
        importFromArrayExpressMenuItem.setText("ArrayExpress...");
        importFromArrayExpressMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicroarrayModule.this.doImportFromArrayExpress();
            }
        });
        return importFromArrayExpressMenuItem;
    }

    private JMenuItem getImportFromGEOMenuItem() {
        JMenuItem importFromGEOMenuItem = new JMenuItem();
        importFromGEOMenuItem.setText("GEO...");
        importFromGEOMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicroarrayModule.this.doImportFromGEO();
            }
        });
        return importFromGEOMenuItem;
    }

    @Override
    public void addImportLinks(QuickLinkPanel quickLinkPanel, List<JXHyperlink> importLinks) {
        importLinks.add(LinkUtil.createLink("Import from ArrayExpress ", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicroarrayModule.this.doImportFromArrayExpress();
            }
        }));
        importLinks.add(LinkUtil.createLink("Import from GEO ", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicroarrayModule.this.doImportFromGEO();
            }
        }));
    }

    private void doImportFromGEO() {
        try {
            ClientApplication application = Session.getSession().getApplication();
            Operation importOperation = new Operation(application.getOperationDefinition(IMPORT_FROM_GEO_ID), new DataBean[0]);
            new TaskImportDialog(application, "Import data from the GEO", null, importOperation);
        }
        catch (Exception me) {
            Session.getSession().getApplication().reportException(me);
        }
    }

    private void doImportFromArrayExpress() {
        try {
            ClientApplication application = Session.getSession().getApplication();
            Operation importOperation = new Operation(application.getOperationDefinition(IMPORT_FROM_ARRAYEXPRESS_ID), new DataBean[0]);
            new TaskImportDialog(application, "Import data from the ArrayExpress", null, importOperation);
        }
        catch (Exception me) {
            Session.getSession().getApplication().reportException(me);
        }
    }

    @Override
    public boolean isImportToolSupported() {
        return true;
    }

    @Override
    public boolean isWorkflowCompatible(DataBean data) {
        return true;
    }

    @Override
    public VisualisationMethod[] getVisualisationMethods() {
        return new VisualisationMethod[]{VisualisationMethods.PHENODATA, VisualisationMethods.ARRAY_LAYOUT, VisualisationMethods.HISTOGRAM, VisualisationMethods.SCATTERPLOT, VisualisationMethods.SCATTERPLOT3D, VisualisationMethods.SCATTERPLOT3DPCA, VisualisationMethods.VOLCANOPLOT, VisualisationMethods.SOM, VisualisationMethods.HIERARCHICAL, VisualisationMethods.EXPRESSION_PROFILE, VisualisationMethods.CLUSTERED_PROFILES, VisualisationMethods.VENN_DIAGRAM, VisualisationMethods.SAMBAM_VIEWER, VisualisationMethods.GBROWSER};
    }

    @Override
    public URL[] getExampleSessionUrls(boolean isStandalone) throws MalformedURLException {
        if (isStandalone) {
            return new URL[]{new URL(STANDALONE_EXAMPLE_SESSION_URL)};
        }
        return new URL[]{new URL(EXAMPLE_SESSION_URL_ARRAY), new URL(EXAMPLE_SESSION_URL_NGS)};
    }

    @Override
    public String[][] getRepositoryWorkflows() {
        return new String[][]{{"Gene expression analysis", "/gene-expression-analysis.bsh"}, {"Protein expression analysis", "/protein-expression-analysis.bsh"}, {"miRNA expression analysis", "/mirna-expression-analysis.bsh"}};
    }

    public static DataBean getProperSource(DataBean dataBean) {
        if (dataBean == null || dataBean.getLinkTargets(DataBean.Link.DERIVATION).size() == 0) {
            return null;
        }
        if (dataBean.getLinkTargets(DataBean.Link.DERIVATION).size() == 1) {
            return dataBean.getLinkTargets(DataBean.Link.DERIVATION).iterator().next();
        }
        LinkedList<DataBean> sourceCollector = new LinkedList<DataBean>();
        for (DataBean source : dataBean.getLinkTargets(DataBean.Link.DERIVATION)) {
            if (!source.queryFeatures("/phenodata").exists()) continue;
            sourceCollector.add(source);
        }
        if (sourceCollector.size() == 0 || sourceCollector.size() > 1) {
            return null;
        }
        return (DataBean)sourceCollector.getFirst();
    }

    public static DataBean[] getSourcePath(DataBean dataBean) {
        LinkedList<DataBean> list = new LinkedList<DataBean>();
        if (MicroarrayModule.getProperSource(dataBean) != null) {
            list.addAll(Arrays.asList(MicroarrayModule.getSourcePath(MicroarrayModule.getProperSource(dataBean))));
        }
        list.add(dataBean);
        return list.toArray(new DataBean[0]);
    }

    @Override
    public boolean isMetadata(DataBean data) {
        return data.queryFeatures("/phenodata").exists();
    }

    @Override
    public void postProcessOutputMetadata(Operation oper, DataBean metadataOutput) throws MicroarrayException, IOException {
        if (!metadataOutput.queryFeatures("/column/original_name").exists()) {
            HashSet<String> insertedNames = new HashSet<String>();
            TableBeanEditor tableEditor = new TableBeanEditor(metadataOutput);
            EditableTable editableTable = tableEditor.getEditable();
            LinkedList<String> newColumn = new LinkedList<String>();
            newColumn.addAll(Arrays.asList(Strings.repeatToArray("", editableTable.getRowCount())));
            editableTable.addColumn("original_name", 1, newColumn);
            for (int ri = 0; ri < editableTable.getRowCount(); ++ri) {
                String sample = editableTable.getValue("sample", ri);
                boolean correctRowFound = false;
                String originalName = null;
                for (Operation.DataBinding binding : oper.getBindings()) {
                    if (!binding.getName().equals(sample)) continue;
                    DataBean ancestor = binding.getData().getUniqueAncestorRecursively(binding.getData());
                    originalName = !ancestor.equals(binding.getData()) ? binding.getData().getName() + " ( " + ancestor.getName() + " )" : binding.getData().getName();
                    correctRowFound = true;
                    break;
                }
                if (!correctRowFound) {
                    originalName = sample;
                }
                if (insertedNames.contains(originalName)) {
                    String separator = "/";
                    int i = 2;
                    while (insertedNames.contains(originalName + "/" + i)) {
                        ++i;
                    }
                    originalName = originalName + "/" + i;
                }
                editableTable.setValue("original_name", ri, originalName);
                insertedNames.add(originalName);
            }
            tableEditor.write();
        }
        if (!metadataOutput.queryFeatures("/column/description").exists()) {
            TableBeanEditor tableEditor = new TableBeanEditor(metadataOutput);
            EditableTable editableTable = tableEditor.getEditable();
            LinkedList<String> newColumn = new LinkedList<String>();
            newColumn.addAll(Arrays.asList(Strings.repeatToArray("", editableTable.getRowCount())));
            editableTable.addColumn("description", newColumn);
            for (int ri = 0; ri < editableTable.getRowCount(); ++ri) {
                String sample = editableTable.getValue("original_name", ri);
                editableTable.setValue("description", ri, sample);
            }
            tableEditor.write();
        }
    }

    @Override
    public String getShortDataName(String categoryName) {
        return BasicModule.shortenDataName(categoryName);
    }

    @Override
    public JPanel getContextLinkPanel(int selectedDataCount) {
        JXHyperlink link;
        final ClientApplication application = Session.getSession().getApplication();
        if (!application.isStandalone()) {
            return null;
        }
        JPanel contentPanel = new JPanel();
        contentPanel.setBackground(Color.WHITE);
        contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        int topMargin = 15;
        int leftMargin = 30;
        c.insets.set(topMargin, leftMargin, 0, 0);
        contentPanel.add((Component)new JLabel(VisualConstants.QUICKLINK_ICON), c);
        boolean currentSelectionVisualisable = false;
        try {
            Visualisation visualisation = VisualisationMethods.GBROWSER.getVisualiser(null);
            if (visualisation != null) {
                List<DataBean> selection = application.getSelectionManager().getSelectedDataBeans();
                currentSelectionVisualisable = visualisation.canVisualise(selection);
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (selectedDataCount > 0 && currentSelectionVisualisable) {
            link = new JXHyperlink((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    application.setVisualisationMethod(VisualisationMethods.GBROWSER, null, application.getSelectionManager().getSelectedDataBeans(), VisualisationFrameManager.FrameType.MAIN);
                }
            });
            link.setText("Open genome browser");
        } else if (selectedDataCount < application.getDataManager().databeans().size()) {
            link = new JXHyperlink((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    application.selectAllItems();
                    boolean canVisualise = false;
                    try {
                        canVisualise = VisualisationMethods.GBROWSER.getVisualiser(null).canVisualise(application.getSelectionManager().getSelectedDataBeans());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (canVisualise) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                application.setVisualisationMethod(VisualisationMethods.GBROWSER, null, application.getSelectionManager().getSelectedDataBeans(), VisualisationFrameManager.FrameType.MAIN);
                            }
                        });
                    } else {
                        application.showDialog("Cannot open genome browser", "Currect dataset selection cannot be visualised in genome browser", "Unselect improper datasets to open genome browser.", DialogInfo.Severity.INFO, true);
                    }
                }
            });
            link.setText("Select all and open genome browser");
        } else {
            return null;
        }
        c.insets.set(topMargin, 5, 0, 0);
        ++c.gridx;
        contentPanel.add((Component)link, c);
        return contentPanel;
    }

    @Override
    public boolean notesVisibleAtStartup() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Chipster";
    }

    @Override
    public String getManualHome() {
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        return configuration.getString("client", "manual-root");
    }

    @Override
    public void addSpeadsheetMenuItems(JPopupMenu spreadsheetPopupMenu, final VisualisationFrame visualisationFrame) {
        JMenuItem annotateMenuItem = new JMenuItem();
        annotateMenuItem.setText("Create dataset and annotate with Bioconductor");
        annotateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualisationUtilities.annotateBySelection(visualisationFrame.getDatas(), MicroarrayModule.ANNOTATION_ID);
            }
        });
        spreadsheetPopupMenu.add(annotateMenuItem);
    }

    @Override
    public List<Boolean> flagLinkableColumns(Table columns, DataBean data) {
        LinkedList<Boolean> flags = new LinkedList<Boolean>();
        flags.add(data.hasTypeTag(TypeTags.CHROMOSOME_IN_FIRST_TABLE_COLUMN));
        flags.add(data.hasTypeTag(TypeTags.START_POSITION_IN_SECOND_TABLE_COLUMN) || data.hasTypeTag(TypeTags.CHROMOSOME_IN_SECOND_TABLE_COLUMN));
        flags.add(data.hasTypeTag(TypeTags.END_POSITION_IN_THIRD_TABLE_COLUMN) || data.hasTypeTag(TypeTags.START_POSITION_IN_THIRD_TABLE_COLUMN));
        flags.add(data.hasTypeTag(TypeTags.END_POSITION_IN_FOURTH_TABLE_COLUMN) || data.hasTypeTag(TypeTags.START_POSITION_IN_FOURTH_TABLE_COLUMN));
        flags.add(data.hasTypeTag(TypeTags.END_POSITION_IN_FIFTH_TABLE_COLUMN));
        for (int i = 4; i < columns.getColumnCount(); ++i) {
            flags.add(false);
        }
        return flags;
    }

    @Override
    public IntegratedEntity createLinkableEntity(Table columns, DataBean data) {
        IntegratedEntity entity = new IntegratedEntity();
        String CHR_KEY = "chromosome";
        String START_KEY = "start";
        String END_KEY = "end";
        int chrColumn = -1;
        if (data.hasTypeTag(TypeTags.CHROMOSOME_IN_FIRST_TABLE_COLUMN)) {
            chrColumn = 0;
        }
        if (data.hasTypeTag(TypeTags.CHROMOSOME_IN_SECOND_TABLE_COLUMN)) {
            chrColumn = 1;
        }
        if (chrColumn != -1) {
            entity.put("chromosome", columns.getStringValue(columns.getColumnNames()[chrColumn]));
        }
        int startColumn = -1;
        if (data.hasTypeTag(TypeTags.START_POSITION_IN_SECOND_TABLE_COLUMN)) {
            startColumn = 1;
        }
        if (data.hasTypeTag(TypeTags.START_POSITION_IN_THIRD_TABLE_COLUMN)) {
            startColumn = 2;
        }
        if (data.hasTypeTag(TypeTags.START_POSITION_IN_FOURTH_TABLE_COLUMN)) {
            startColumn = 3;
        }
        if (startColumn != -1) {
            entity.put("start", columns.getStringValue(columns.getColumnNames()[startColumn]));
        }
        int endColumn = -1;
        if (data.hasTypeTag(TypeTags.END_POSITION_IN_THIRD_TABLE_COLUMN)) {
            endColumn = 2;
        }
        if (data.hasTypeTag(TypeTags.END_POSITION_IN_FOURTH_TABLE_COLUMN)) {
            endColumn = 3;
        }
        if (data.hasTypeTag(TypeTags.END_POSITION_IN_FIFTH_TABLE_COLUMN)) {
            endColumn = 4;
        }
        if (endColumn != -1) {
            entity.put("end", columns.getStringValue(columns.getColumnNames()[endColumn]));
        }
        return entity;
    }

    public static class VisualisationMethods {
        public static VisualisationMethod ARRAY_LAYOUT = new VisualisationMethod("Array layout", ArrayLayout.class, VisualConstants.ARRAY_MENUICON, -1, 9.0E-4);
        public static VisualisationMethod HISTOGRAM = new VisualisationMethod("Histogram", Histogram.class, VisualConstants.HISTOGRAM_MENUICON, -1, 0.024);
        public static VisualisationMethod HEATMAP = new VisualisationMethod("Heatmap", Heatmap.class, VisualConstants.ARRAY_MENUICON, -1, 9.0E-4);
        public static VisualisationMethod SCATTERPLOT = new VisualisationMethod("Scatterplot", Scatterplot.class, VisualConstants.SCATTER_MENUICON, -1, 0.039);
        public static VisualisationMethod SCATTERPLOT3D = new VisualisationMethod("3D Scatterplot", Scatterplot3D.class, VisualConstants.SCATTER3D_MENUICON, -1, 0.082);
        public static VisualisationMethod SCATTERPLOT3DPCA = new VisualisationMethod("3D Scatterplot for PCA", Scatterplot3DPCA.class, VisualConstants.SCATTER3DPCA_MENUICON, -1, 0.082);
        public static VisualisationMethod VOLCANOPLOT = new VisualisationMethod("Volcano plot", Volcanoplot.class, VisualConstants.VOLCANO_MENUICON, -1, 0.039);
        public static VisualisationMethod SOM = new VisualisationMethod("SOM", SOM.class, VisualConstants.SOM_MENUICON, 3, 0.034);
        public static VisualisationMethod HIERARCHICAL = new VisualisationMethod("Hierarchical clustering", HierarchicalClustering.class, VisualConstants.HC_MENUICON, 3, 0.09);
        public static VisualisationMethod EXPRESSION_PROFILE = new VisualisationMethod("Expression profile", ExpressionProfile.class, VisualConstants.PROFILE_MENUICON, -1, 0.1);
        public static VisualisationMethod CLUSTERED_PROFILES = new VisualisationMethod("Clustered profiles", ClusteredProfiles.class, VisualConstants.PROFILES_MENUICON, -1, 0.087);
        public static VisualisationMethod VENN_DIAGRAM = new VisualisationMethod("Venn-diagram", VennDiagram.class, VisualConstants.VENN_MENUICON, 1, -1.0);
        public static VisualisationMethod GBROWSER = new VisualisationMethod("Genome browser", ChipsterGBrowserVisualisation.class, VisualConstants.SCATTER_MENUICON, 1, -1.0, "genomeBrowser.html");
        public static VisualisationMethod SAMBAM_VIEWER = new VisualisationMethod("BAM viewer", SamBamViewer.class, VisualConstants.TEXT_MENUICON, 1, -1.0);
        public static VisualisationMethod PHENODATA = new VisualisationMethod("Phenodata editor", PhenodataEditor.class, VisualConstants.PHENODATA_MENUICON, 3, 0.0, "visualisation-phenodata.html");
    }

    public static class TypeTags {
        public static final TypeTag RAW_AFFYMETRIX_EXPRESSION_VALUES = new TypeTag("raw-arrymetrix-expression-values", "must be in CEL format");
        public static final TypeTag RAW_EXPRESSION_VALUES = new TypeTag("raw-expression-values", "");
        public static final TypeTag NORMALISED_EXPRESSION_VALUES = new TypeTag("normalised-expression-values", "must have columns following name pattern \"chip.*\"");
        public static final TypeTag GENENAMES = new TypeTag("genenames", "must have column \" \" or \"identifier\"");
        public static final TypeTag SIGNIFICANT_EXPRESSION_FOLD_CHANGES = new TypeTag("significant-expression-fold-changes", "must have columns following name patterns \"FC.*\" and \"p.*\"");
        public static final TypeTag EXPRESSION_PRIMARY_COMPONENTS_GENEWISE = new TypeTag("expression-primary-components-genewise", "");
        public static final TypeTag EXPRESSION_PRIMARY_COMPONENTS_CHIPWISE = new TypeTag("expression-primary-components-chipwise", "");
        public static final TypeTag ORDERED_GENOMIC_ENTITIES = new TypeTag("ordered-genomic-entities", "");
        public static final TypeTag CLUSTERED_EXPRESSION_VALUES = new TypeTag("clustered-expression-values", "must have column \"cluster\"");
        public static final TypeTag SOM_CLUSTERED_EXPRESSION_VALUES = new TypeTag("som-clustered-expression-values", "must have columns \"colours\", \"distance2first\", \"cluster\", \"griddim\"");
        public static final TypeTag BAM_FILE = new TypeTag("bam-file", "");
        public static final TypeTag FASTA_FILE = new TypeTag("fasta-file", "");
        public static final TypeTag GTF_FILE = new TypeTag("gtf-file", "");
        public static final TypeTag TABLE_WITH_HASH_HEADER = new TypeTag("table-with-hash-header", "header rows start with #");
        public static final TypeTag TABLE_WITH_DOUBLE_HASH_HEADER = new TypeTag("table-with-double-hash-header", "header rows start with ##");
        public static final TypeTag CHROMOSOME_IN_FIRST_TABLE_COLUMN = new TypeTag("chromosome-in-first-table-column", "first column of table is chromosome");
        public static final TypeTag CHROMOSOME_IN_SECOND_TABLE_COLUMN = new TypeTag("chromosome-in-second-table-column", "second column of table is chromosome");
        public static final TypeTag START_POSITION_IN_SECOND_TABLE_COLUMN = new TypeTag("start-position-in-second-table-column", "second column of table is start position");
        public static final TypeTag START_POSITION_IN_THIRD_TABLE_COLUMN = new TypeTag("start-position-in-third-table-column", "third column of table is start position");
        public static final TypeTag START_POSITION_IN_FOURTH_TABLE_COLUMN = new TypeTag("start-position-in-fourth-table-column", "fourth column of table is start position");
        public static final TypeTag END_POSITION_IN_THIRD_TABLE_COLUMN = new TypeTag("end-position-in-third-table-column", "third column of table is end position");
        public static final TypeTag END_POSITION_IN_FOURTH_TABLE_COLUMN = new TypeTag("end-position-in-fourth-table-column", "fourth column of table is end position");
        public static final TypeTag END_POSITION_IN_FIFTH_TABLE_COLUMN = new TypeTag("end-position-in-fifth-table-column", "fifth column of table is end position");
        public static final TypeTag CNA = new TypeTag("cna-data", "data file produced by cna tools");
        public static final TypeTag MOTHUR_OLIGOS = new TypeTag("Mothur oligos data", "Mothur oligos data");
        public static final TypeTag MOTHUR_NAMES = new TypeTag("Mothur names data", "Mothur names data");
        public static final TypeTag MOTHUR_GROUPS = new TypeTag("Mothur groups data", "Mothur groups data");
    }
}

