/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.filebroker.NotEnoughDiskSpaceException;
import fi.csc.microarray.messaging.BooleanMessageListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.UrlListMessageListener;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.UrlMessage;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.UrlTransferUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.zip.InflaterInputStream;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class JMSFileBrokerClient
implements FileBrokerClient {
    private static final int SPACE_REQUEST_TIMEOUT = 300;
    private static final int FILE_AVAILABLE_TIMEOUT = 5;
    private static final Logger logger = Logger.getLogger(JMSFileBrokerClient.class);
    private MessagingTopic urlTopic;
    private boolean useChunked;
    private boolean useCompression;
    private String localFilebrokerPath;

    public JMSFileBrokerClient(MessagingTopic urlTopic, String localFilebrokerPath) throws JMSException {
        this.urlTopic = urlTopic;
        this.localFilebrokerPath = localFilebrokerPath;
        this.useChunked = DirectoryLayout.getInstance().getConfiguration().getBoolean("messaging", "use-chunked-http");
        this.useCompression = DirectoryLayout.getInstance().getConfiguration().getBoolean("messaging", "use-compression");
    }

    public JMSFileBrokerClient(MessagingTopic urlTopic) throws JMSException {
        this(urlTopic, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL addFile(File file, IOUtils.CopyProgressListener progressListener) throws FileBrokerException, JMSException, IOException {
        if (file.length() > 0L && !this.requestDiskSpace(file.length())) {
            throw new NotEnoughDiskSpaceException();
        }
        URL url = this.getNewUrl(this.useCompression);
        if (url == null) {
            throw new FileBrokerException("New URL is null.");
        }
        if (this.localFilebrokerPath != null && !this.useCompression) {
            String filename = IOUtils.getFilenameWithoutPath(url);
            File dest = new File(this.localFilebrokerPath, filename);
            boolean success = file.renameTo(dest);
            if (!success) {
                IOUtils.copy(file, dest);
            }
        } else {
            FileInputStream stream = new FileInputStream(file);
            try {
                UrlTransferUtil.uploadStream(url, stream, this.useChunked, this.useCompression, progressListener);
            }
            finally {
                IOUtils.closeIfPossible(stream);
            }
        }
        return url;
    }

    @Override
    public URL addFile(InputStream file, long contentLength, IOUtils.CopyProgressListener progressListener) throws FileBrokerException, JMSException, IOException {
        if (contentLength > 0L && !this.requestDiskSpace(contentLength)) {
            throw new NotEnoughDiskSpaceException();
        }
        URL url = this.getNewUrl(this.useCompression);
        if (url == null) {
            throw new FileBrokerException("New URL is null.");
        }
        logger.debug((Object)("uploading new file: " + url));
        UrlTransferUtil.uploadStream(url, file, this.useChunked, this.useCompression, progressListener);
        logger.debug((Object)("successfully uploaded: " + url));
        return url;
    }

    @Override
    public InputStream getFile(URL url) throws IOException {
        InputStream payload = null;
        payload = url.openStream();
        long waitStartTime = System.currentTimeMillis();
        int waitTime = 10;
        while (payload.available() < 1 && waitStartTime + 5000L > System.currentTimeMillis()) {
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            waitTime *= 2;
        }
        if (url.toString().endsWith(".compressed")) {
            return new InflaterInputStream(payload);
        }
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkFile(URL url, long contentLength) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            if (connection.getResponseCode() == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.disconnectIfPossible(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getNewUrl(boolean useCompression) throws JMSException {
        URL url;
        logger.debug((Object)"getting new url");
        UrlMessageListener replyListener = new UrlMessageListener();
        try {
            CommandMessage urlRequestMessage = new CommandMessage("url-request");
            if (useCompression) {
                urlRequestMessage.addParameter("use-compression");
            }
            this.urlTopic.sendReplyableMessage(urlRequestMessage, replyListener);
            url = replyListener.waitForReply(300L, TimeUnit.SECONDS);
        }
        finally {
            replyListener.cleanUp();
        }
        logger.debug((Object)("new url is: " + url));
        return url;
    }

    @Override
    public List<URL> getPublicFiles() throws JMSException {
        return this.fetchPublicFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URL> fetchPublicFiles() throws JMSException {
        List<URL> urlList;
        UrlListMessageListener replyListener = new UrlListMessageListener();
        try {
            CommandMessage fileRequestMessage = new CommandMessage("public-url-list-request");
            this.urlTopic.sendReplyableMessage(fileRequestMessage, replyListener);
            urlList = replyListener.waitForReply(5L, TimeUnit.SECONDS);
        }
        finally {
            replyListener.cleanUp();
        }
        return urlList;
    }

    @Override
    public URL getPublicUrl() throws JMSException {
        return this.fetchPublicUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL fetchPublicUrl() throws JMSException {
        URL url;
        UrlMessageListener replyListener = new UrlMessageListener();
        try {
            CommandMessage urlRequestMessage = new CommandMessage("public-url-request");
            this.urlTopic.sendReplyableMessage(urlRequestMessage, replyListener);
            url = replyListener.waitForReply(300L, TimeUnit.SECONDS);
        }
        finally {
            replyListener.cleanUp();
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getFile(File destFile, URL url) throws IOException {
        if (this.localFilebrokerPath != null) {
            File fileInFilebrokerCache = new File(this.localFilebrokerPath, UrlTransferUtil.parseFilename(url));
            if (!fileInFilebrokerCache.exists()) return;
            boolean linkCreated = Files.createSymbolicLink(fileInFilebrokerCache, destFile);
            if (linkCreated) return;
            IOUtils.copy(fileInFilebrokerCache, destFile);
            return;
        }
        BufferedInputStream inputStream = null;
        BufferedOutputStream fileStream = null;
        try {
            inputStream = new BufferedInputStream(this.getFile(url));
            fileStream = new BufferedOutputStream(new FileOutputStream(destFile));
            IOUtils.copy((InputStream)inputStream, fileStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(inputStream);
            IOUtils.closeIfPossible(fileStream);
            throw throwable;
        }
        IOUtils.closeIfPossible(inputStream);
        IOUtils.closeIfPossible(fileStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestDiskSpace(long size) throws JMSException {
        Boolean spaceAvailable;
        BooleanMessageListener replyListener = new BooleanMessageListener();
        try {
            CommandMessage spaceRequestMessage = new CommandMessage("disk-space-request");
            spaceRequestMessage.addNamedParameter("disk-space", String.valueOf(size));
            this.urlTopic.sendReplyableMessage(spaceRequestMessage, replyListener);
            spaceAvailable = replyListener.waitForReply(300L, TimeUnit.SECONDS);
        }
        finally {
            replyListener.cleanUp();
        }
        if (spaceAvailable == null) {
            logger.warn((Object)"did not get response for space request");
            return false;
        }
        return spaceAvailable;
    }

    private class UrlMessageListener
    extends TempTopicMessagingListenerBase {
        private URL newUrl;
        private CountDownLatch latch = new CountDownLatch(1);

        private UrlMessageListener() {
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            if (msg instanceof UrlMessage) {
                UrlMessage urlMessage = (UrlMessage)msg;
                this.newUrl = urlMessage.getUrl();
                this.latch.countDown();
            }
        }

        public URL waitForReply(long timeout, TimeUnit unit) {
            try {
                this.latch.await(timeout, unit);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"interrupted while waiting for latch", (Throwable)e);
            }
            return this.newUrl;
        }
    }
}

