/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.description;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.description.SADLTokeniser;
import fi.csc.microarray.exception.MicroarrayException;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class SADLTokeniserTest {
    @BeforeTest
    public void init() throws IOException, ConfigurationLoader.IllegalConfigurationException {
        DirectoryLayout.initialiseSimpleLayout().getConfiguration();
    }

    @Test(groups={"unit"})
    public void testTokenising() throws MicroarrayException, IOException {
        SADLTokeniser tokens = new SADLTokeniser("TOOL chainsaw:\"This is a \\\"chainsaw\\\" (electric)\" (Chainsaw can be used for \"cutting\" trees (like pinetrees\\).)", "");
        Assert.assertEquals((String)tokens.next(), (String)"TOOL");
        Assert.assertEquals((String)tokens.next(), (String)"chainsaw");
        Assert.assertEquals((String)tokens.next(), (String)":");
        Assert.assertEquals((String)tokens.next(), (String)"This is a \"chainsaw\" (electric)");
        Assert.assertEquals((String)tokens.next(), (String)"Chainsaw can be used for \"cutting\" trees (like pinetrees).");
    }

    public static void main(String[] args) throws MicroarrayException, IOException, ConfigurationLoader.IllegalConfigurationException {
        DirectoryLayout.initialiseSimpleLayout().getConfiguration();
        new SADLTokeniserTest().testTokenising();
    }
}

