/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.ScatterplotValue;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.SelectionText;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.PassiveItem;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ScatterplotPoint;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Selectable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.util.ScaleUtil;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class ScatterplotTrack
extends Track {
    private static final int TOP_MARGIN = 0;
    private TreeMap<IndexKey, ScatterplotPoint> data = new TreeMap();
    private Color defaultColor;
    private int height;
    private float minValue;
    private float maxValue;
    private int minSize = 2;
    private boolean xAxisVisible = false;
    private DataType column = null;
    private int floatListIndex;
    private float[] scale;

    private ScatterplotTrack(Color color, int height, float minValue, float maxValue) {
        this.defaultColor = color;
        this.height = height;
        int stepCount = 4;
        if (height < 40) {
            stepCount = 2;
        }
        this.scale = ScaleUtil.generateScaleValues(minValue, maxValue, stepCount);
        this.minValue = this.scale[0];
        this.maxValue = this.scale[stepCount - 1];
    }

    public ScatterplotTrack(Color color, int height, float minValue, float maxValue, DataType column) {
        this(color, height, minValue, maxValue);
        this.column = column;
    }

    public ScatterplotTrack(Color color, int height, float minValue, float maxValue, int floatArrayIndex, int minBpLength, long maxBpLength) {
        this(color, height, minValue, maxValue);
        this.floatListIndex = floatArrayIndex;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    public void setXAxisVisible(boolean visible) {
        this.xAxisVisible = visible;
    }

    @Override
    public List<Selectable> getSelectables() {
        LinkedList<Selectable> items = new LinkedList<Selectable>();
        if (this.data != null) {
            items.add(new PassiveItem(this.getScaleDrawables()));
            Iterator<IndexKey> iter = this.data.keySet().iterator();
            while (iter.hasNext()) {
                ScatterplotPoint point = this.data.get(iter.next());
                if (!this.getView().requestIntersects(point.getRegion())) {
                    iter.remove();
                    continue;
                }
                point.render(this.getView(), this.minSize, this);
                items.add(point);
            }
        }
        return items;
    }

    private List<Drawable> getScaleDrawables() {
        LinkedList<Drawable> drawables = new LinkedList<Drawable>();
        if (this.getTrackHeight() > 20) {
            Color scaleColor = Color.black;
            int CHAR_WIDTH = 6;
            int START_OFFSET = 3;
            int END_OFFSET = -13;
            int textOffset = 3;
            int maxTextWidth = 0;
            for (float scaleValue : this.scale) {
                String text = "" + ScaleUtil.format(scaleValue);
                maxTextWidth = Math.max(maxTextWidth, text.length() * 6);
            }
            int scaleX = super.getVisibleWidth() - maxTextWidth - 4;
            for (float scaleValue : this.scale) {
                int lineY = this.getY(scaleValue);
                int textY = this.getY(scaleValue) + 6;
                int lineX2 = scaleX - 6;
                String text = "" + ScaleUtil.format(scaleValue);
                if (this.xAxisVisible && scaleValue == 0.0f) {
                    lineX2 = 0;
                }
                drawables.add(new LineDrawable(scaleX, lineY, lineX2, lineY, scaleColor));
                drawables.add(new TextDrawable(scaleX + 4, textY + textOffset, text, scaleColor));
                textOffset -= 16 / this.scale.length;
            }
            drawables.add(new LineDrawable(scaleX, this.getY(this.minValue), scaleX, this.getY(this.maxValue), scaleColor));
        }
        return drawables;
    }

    public int getY(float value) {
        return (int)((value - this.minValue) / (this.maxValue - this.minValue) * (float)(this.height - 0 - 2) + 1.0f);
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        for (Feature feature : dataResult.getFeatures()) {
            IndexKey key = feature.getIndexKey();
            if (this.data.containsKey(key)) continue;
            Float value = null;
            Color itemColor = this.defaultColor;
            SelectionText text = null;
            if (feature.getValueObject() instanceof SelectionText) {
                text = (SelectionText)feature.getValueObject();
            }
            if (this.column != null) {
                Object obj = feature.values.get((Object)this.column);
                if (obj instanceof SelectionText) {
                    SelectionText textObj;
                    text = textObj = (SelectionText)obj;
                }
                if (obj instanceof ScatterplotValue) {
                    ScatterplotValue valueObj = (ScatterplotValue)obj;
                    value = valueObj.getScatterplotValue();
                    if (valueObj.getScatterplotColor() != null) {
                        itemColor = valueObj.getScatterplotColor();
                    }
                } else if (obj != null) {
                    value = (Float)obj;
                }
            } else {
                List floatList = (List)feature.values.get((Object)DataType.FLOAT_LIST);
                value = (Float)floatList.get(this.floatListIndex);
            }
            ScatterplotPoint point = new ScatterplotPoint(feature.region, key, value, itemColor, text);
            if (value == null) continue;
            this.data.put(key, point);
        }
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.REGION);
        if (this.column == null) {
            this.addDataType(DataType.FLOAT_LIST);
        } else {
            this.addDataType(this.column);
        }
    }

    @Override
    public int getTrackHeight() {
        return this.height;
    }
}

