/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserSettings;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageAverageTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageEstimateTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.DensityGraphTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadPileTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReferenceSequenceTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;

public class SampleTrackGroup
extends TrackGroup {
    private final Color fontColor = Color.black;
    protected CoverageEstimateTrack coverageEstimateTrack;
    protected ReadPileTrack readPileForward;
    protected ReferenceSequenceTrack referenceSequence;
    protected ReadPileTrack readPileReverse;
    protected CoverageTrack coverageTrack;
    protected CoverageAverageTrack coverageAverageTrack;
    protected DensityGraphTrack densityGraphTrack;
    protected SeparatorTrack separatorReadPile;
    protected SeparatorTrack separatorReferenceSequence;
    protected SeparatorTrack separatorDensity;
    protected SeparatorTrack separatorQualityCoverage;
    protected SeparatorTrack sepTrackGel;
    protected SeparatorTrack separatorCoverageEstimate;
    private DataThread referenceSequenceFile;
    private DataThread detailsDataThread;
    private DataThread coverageDataThread;
    private DataThread estimateDataThread;
    private boolean strandSpecific;
    private boolean coverage;
    private boolean coverageEstimate;
    private boolean reads;
    private boolean highlightSnp;
    private boolean densityGraph;
    private boolean fullMode;

    public SampleTrackGroup(GBrowserView view, DataThread details, DataThread coverage, DataThread estimate, DataThread seqFile, String title) {
        super(view);
        super.setName(title);
        this.detailsDataThread = details;
        this.coverageDataThread = coverage;
        this.estimateDataThread = estimate;
        this.referenceSequenceFile = seqFile;
        this.setSettingsEnabled(true);
    }

    public void initialise() {
        if (this.detailsDataThread != null && this.reads) {
            this.readPileForward = new ReadPileTrack(this.referenceSequenceFile, this.fontColor);
            this.readPileForward.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.readPileForward.setView(this.view);
            this.readPileForward.addDataThread(this.detailsDataThread);
            this.readPileForward.setSNPHighlight(this.highlightSnp);
            this.addTrack(this.readPileForward);
            this.separatorReadPile = new SeparatorTrack(Color.gray, 1);
            this.separatorReadPile.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.separatorReadPile.setView(this.view);
            this.separatorReadPile.setTrackName("Reads");
            this.addTrack(this.separatorReadPile);
            this.getStatusAnimation().addDataThread(this.detailsDataThread);
        }
        if (this.referenceSequenceFile != null) {
            this.referenceSequence = new ReferenceSequenceTrack();
            this.referenceSequence.setViewLimits(0L, GBrowserConstants.SHOW_REFERENCE_AT);
            this.referenceSequence.setView(this.view);
            this.referenceSequence.addDataThread(this.referenceSequenceFile);
            this.addTrack(this.referenceSequence);
            this.separatorReferenceSequence = new SeparatorTrack(Color.gray, 1);
            this.separatorReferenceSequence.setViewLimits(0L, GBrowserConstants.SHOW_REFERENCE_AT);
            this.separatorReferenceSequence.setView(this.view);
            this.separatorReferenceSequence.setTrackName("Reads");
            this.addTrack(this.separatorReferenceSequence);
            this.getStatusAnimation().addDataThread(this.referenceSequenceFile);
        }
        if (this.detailsDataThread != null) {
            this.addCoverageEstimate();
            if (this.reads) {
                this.readPileReverse = new ReadPileTrack(this.referenceSequenceFile, this.fontColor);
                this.readPileReverse.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
                this.readPileReverse.setView(this.view);
                this.readPileReverse.addDataThread(this.detailsDataThread);
                this.readPileReverse.setSNPHighlight(this.highlightSnp);
                this.readPileReverse.setStrand(Strand.REVERSE);
                this.addTrack(this.readPileReverse);
                if (this.fullMode) {
                    this.readPileForward.setLayoutMode(LayoutTool.LayoutMode.FULL);
                    this.readPileReverse.setLayoutMode(LayoutTool.LayoutMode.FULL);
                }
                SeparatorTrack sepTrackReads2 = new SeparatorTrack(Color.gray, 1);
                sepTrackReads2.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
                sepTrackReads2.setView(this.view);
                sepTrackReads2.setTrackName("Reads");
                this.addTrack(sepTrackReads2);
            }
            if (this.coverage) {
                this.coverageTrack = new CoverageTrack(this.coverageDataThread, this.referenceSequenceFile);
                this.coverageTrack.setViewLimits(0L, GBrowserConstants.SHOW_AVERAGES);
                this.coverageTrack.setView(this.view);
                this.coverageTrack.setTrackName("Coverage");
                this.coverageTrack.setStrandSpecificCoverageType(this.strandSpecific);
                this.coverageTrack.setSNPHighlight(this.highlightSnp);
                this.addTrack(this.coverageTrack);
                this.coverageAverageTrack = new CoverageAverageTrack();
                this.coverageAverageTrack.setViewLimits(GBrowserConstants.SHOW_AVERAGES, GBrowserConstants.SWITCH_VIEWS_AT);
                this.coverageAverageTrack.addDataThread(this.coverageDataThread);
                this.coverageAverageTrack.setView(this.view);
                this.coverageAverageTrack.setTrackName("Coverage");
                this.coverageAverageTrack.setStrandSpecificCoverageType(this.strandSpecific);
                this.addTrack(this.coverageAverageTrack);
                this.getStatusAnimation().addDataThread(this.coverageDataThread);
            }
            if (this.coverage && this.densityGraph) {
                this.separatorDensity = new SeparatorTrack(Color.gray, 1);
                this.separatorDensity.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
                this.separatorDensity.setView(this.view);
                this.separatorDensity.setTrackName("DensityGraphTrack");
                this.addTrack(this.separatorDensity);
            }
            if (this.densityGraph) {
                this.densityGraphTrack = new DensityGraphTrack(Color.WHITE);
                this.densityGraphTrack.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
                this.densityGraphTrack.setView(this.view);
                this.densityGraphTrack.addDataThread(this.coverageDataThread);
                this.addTrack(this.densityGraphTrack);
            }
        }
    }

    protected void addCoverageEstimate() {
        if (this.coverageEstimate) {
            this.coverageEstimateTrack = new CoverageEstimateTrack();
            this.coverageEstimateTrack.setViewLimits(GBrowserConstants.SWITCH_VIEWS_AT, Long.MAX_VALUE);
            this.coverageEstimateTrack.setView(this.view);
            this.coverageEstimateTrack.addDataThread(this.estimateDataThread);
            this.coverageEstimateTrack.setTrackName("CoverageEstimate");
            this.coverageEstimateTrack.setStrandSpecificCoverageType(this.strandSpecific);
            this.addTrack(this.coverageEstimateTrack);
            this.getStatusAnimation().addDataThread(this.estimateDataThread);
        }
    }

    @Override
    public void addTracks() {
        this.tracks.clear();
        if (!this.isMinimized()) {
            this.fullMode = this.isShowMore();
            this.initialise();
        }
    }

    public void setCoverageType(GBrowserSettings.CoverageType type) {
        if (type == GBrowserSettings.CoverageType.NONE) {
            this.coverage = false;
            this.coverageEstimate = false;
        } else if (type == GBrowserSettings.CoverageType.TOTAL) {
            this.coverage = true;
            this.coverageEstimate = true;
            this.strandSpecific = false;
        } else if (type == GBrowserSettings.CoverageType.STRAND) {
            this.coverage = true;
            this.coverageEstimate = true;
            this.strandSpecific = true;
        }
        this.addTracks();
    }

    public void setReadsVisible(boolean selected) {
        this.reads = selected;
    }

    public void setHighlightSnp(boolean selected) {
        this.highlightSnp = selected;
        this.addTracks();
    }

    public void setDensityGraphVisible(boolean selected) {
        this.densityGraph = selected;
        this.addTracks();
    }
}

