/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Cigar;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;

public class QualityCoverageTrack
extends Track {
    private Collection<Feature> forwardReads = new TreeSet<Feature>();
    private Color forwardColor;

    public QualityCoverageTrack(Color forwardColor) {
        this.forwardColor = forwardColor;
        this.setStrand(Strand.BOTH);
    }

    private Collection<Drawable> getDrawableReads(Collection<Feature> reads, Color color) {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        Chromosome chr = this.getView().getBpRegion().start.chr;
        TreeMap<Long, Float> collector = this.getQualities(reads);
        int bpWidth = (int)((long)this.getView().getWidth() / this.getView().getBpRegion().getLength());
        int bottomlineY = 0;
        Iterator<Long> bpLocations = collector.keySet().iterator();
        if (bpLocations.hasNext()) {
            Long lastBpLocation = bpLocations.next();
            int startX = this.getView().bpToTrack(new BpCoord(lastBpLocation, chr));
            long startY = (long)collector.get(lastBpLocation).floatValue();
            drawables.add(new LineDrawable(0, bottomlineY, startX - bpWidth, bottomlineY, color));
            drawables.add(new LineDrawable(startX - bpWidth, bottomlineY, startX, (int)((long)bottomlineY + startY), color));
            while (bpLocations.hasNext()) {
                Long currentBpLocation = bpLocations.next();
                startX = this.getView().bpToTrack(new BpCoord(lastBpLocation, chr));
                startY = (long)collector.get(lastBpLocation).floatValue();
                int endX = this.getView().bpToTrack(new BpCoord(currentBpLocation, chr));
                long endY = (long)collector.get(currentBpLocation).floatValue();
                if (currentBpLocation - lastBpLocation == 1L) {
                    drawables.add(new LineDrawable(startX, (int)((long)bottomlineY + startY), endX, (int)((long)bottomlineY + endY), color));
                } else {
                    drawables.add(new LineDrawable(startX, (int)((long)bottomlineY + startY), startX + bpWidth, bottomlineY, color));
                    drawables.add(new LineDrawable(startX + bpWidth, bottomlineY, endX - bpWidth, bottomlineY, color));
                    drawables.add(new LineDrawable(endX - bpWidth, bottomlineY, endX, (int)((long)bottomlineY + endY), color));
                }
                lastBpLocation = currentBpLocation;
            }
            int endX = this.getView().bpToTrack(new BpCoord(lastBpLocation, chr));
            long endY = (long)collector.get(lastBpLocation).floatValue();
            drawables.add(new LineDrawable(endX, (int)((long)bottomlineY + endY), endX + bpWidth, bottomlineY, color));
            drawables.add(new LineDrawable(endX + bpWidth, bottomlineY, this.getView().getWidth(), bottomlineY, color));
        }
        collector.clear();
        return drawables;
    }

    private TreeMap<Long, Float> getQualities(Collection<Feature> reads) {
        TreeMap<Long, Float> collector = new TreeMap<Long, Float>();
        Iterator<Feature> iter = reads.iterator();
        while (iter.hasNext()) {
            Feature read = iter.next();
            if (!read.region.intersects(this.getView().getBpRegion())) {
                iter.remove();
                continue;
            }
            Cigar cigar = (Cigar)read.values.get((Object)DataType.CIGAR);
            String quality = (String)read.values.get((Object)DataType.QUALITY);
            if (quality == null) continue;
            for (int i = 0; i < quality.length(); ++i) {
                long refIndex = cigar.getReferenceIndex(i);
                if (refIndex == -1L) continue;
                Long bp = refIndex + read.region.start.bp;
                char qualityChar = quality.charAt(i);
                float qualityValue = (float)(qualityChar - 33) / 25.0f;
                if (!collector.containsKey(bp)) {
                    collector.put(bp, Float.valueOf(qualityValue));
                    continue;
                }
                collector.put(bp, Float.valueOf(collector.get(bp).floatValue() + qualityValue));
            }
        }
        return collector;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        drawables.addAll(this.getDrawableReads(this.forwardReads, this.forwardColor));
        return drawables;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        for (Feature content : dataResult.getFeatures()) {
            if (this.getStrand() != content.values.get((Object)DataType.STRAND) && this.getStrand() != Strand.BOTH) continue;
            this.forwardReads.add(content);
        }
    }

    @Override
    public int getTrackHeight() {
        return 100;
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.ID);
        this.addDataType(DataType.STRAND);
        this.addDataType(DataType.QUALITY);
        this.addDataType(DataType.CIGAR);
    }

    @Override
    public boolean canExpandDrawables() {
        return true;
    }

    @Override
    public String getTrackName() {
        return "QualityCoverageTrack";
    }
}

