/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class CoverageEstimateTrack
extends Track {
    public static final int SAMPLING_GRANULARITY = 4;
    private static final int MAX_VALUE_COUNT = 1000;
    private SortedSet<Feature> values = new TreeSet<Feature>();
    private LinkedList<Feature> valueStorageOrder = new LinkedList();
    private boolean strandSpecificCoverageType;

    @Override
    public Collection<Drawable> getDrawables() {
        Color reverseColor;
        Color forwardColor;
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        while (this.values.size() > 1000) {
            Feature oldest = this.valueStorageOrder.pop();
            this.values.remove(oldest);
        }
        LinkedList<RegionValue> forward = new LinkedList<RegionValue>();
        LinkedList<RegionValue> reverse = new LinkedList<RegionValue>();
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Feature regCont = (Feature)iterator.next();
            if (!this.getView().requestIntersects(regCont.region)) {
                iterator.remove();
                continue;
            }
            int x1 = this.getView().bpToTrack(regCont.region.start);
            int x2 = this.getView().bpToTrack(regCont.region.end);
            x2 = Math.max(x2, x1 + 2);
            int fCount = (Integer)regCont.values.get((Object)DataType.COVERAGE_ESTIMATE_FORWARD);
            int rCount = (Integer)regCont.values.get((Object)DataType.COVERAGE_ESTIMATE_REVERSE);
            if (!this.strandSpecificCoverageType) {
                fCount += rCount;
                rCount = 0;
            }
            forward.add(new RegionValue(x1, x2, (float)fCount / (float)regCont.region.getLength().longValue()));
            reverse.add(new RegionValue(x1, x2, (float)rCount / (float)regCont.region.getLength().longValue()));
        }
        float[] continuousForward = this.makeContinuous(forward, this.getView().getWidth(), this.getView().getWidth() / 4 * 4);
        float[] continuousReverse = this.makeContinuous(reverse, this.getView().getWidth(), this.getView().getWidth() / 4 * 4);
        int[] smoohtForward = this.smooth(continuousForward);
        int[] smoohtReverse = this.smooth(continuousReverse);
        int y = 0;
        if (this.strandSpecificCoverageType) {
            forwardColor = GBrowserConstants.FORWARD_COLOR;
            reverseColor = GBrowserConstants.REVERSE_COLOR;
        } else {
            forwardColor = GBrowserConstants.getCoverageColor();
            reverseColor = null;
        }
        for (int i = 0; i < smoohtForward.length; ++i) {
            int fValue = smoohtForward[i];
            int rValue = smoohtReverse[i];
            drawables.add(new RectDrawable(i, y, 1, fValue, forwardColor, null));
            if (!this.strandSpecificCoverageType) continue;
            drawables.add(new RectDrawable(i, y, 1, rValue, reverseColor, null));
        }
        return drawables;
    }

    private float[] makeContinuous(List<RegionValue> points, int width, int maxPointDistance) {
        RegionValue lastPoint = null;
        float[] continuous = new float[width];
        for (RegionValue point : points) {
            int i;
            for (i = point.start; i < point.end; ++i) {
                if (i < 0 || i >= width) continue;
                continuous[i] = point.value;
            }
            if (lastPoint != null && lastPoint.end < point.start && point.start - lastPoint.start <= maxPointDistance) {
                for (i = lastPoint.end; i < point.start; ++i) {
                    if (i < 0 || i >= width) continue;
                    continuous[i] = (point.value + lastPoint.value) / 2.0f;
                }
            }
            lastPoint = point;
        }
        return continuous;
    }

    private int[] smooth(float[] values) {
        int WINDOW = 8;
        int[] smooth = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            int sum = 0;
            int divisor = 8;
            for (int j = i - 4; j < i + 4; ++j) {
                if (j >= 0 && j < values.length) {
                    sum = (int)((float)sum + values[j]);
                    continue;
                }
                --divisor;
            }
            smooth[i] = sum / divisor;
        }
        return smooth;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        for (Feature content : dataResult.getFeatures()) {
            if (!this.getView().requestIntersects(content.region) || !content.values.containsKey((Object)DataType.COVERAGE_ESTIMATE_FORWARD)) continue;
            this.values.add(content);
            this.valueStorageOrder.add(content);
        }
    }

    @Override
    public void defineDataTypes() {
        if (this.isSuitableViewLength()) {
            this.addDataType(DataType.COVERAGE_ESTIMATE_FORWARD);
            this.addDataType(DataType.COVERAGE_ESTIMATE_REVERSE);
        } else {
            this.addDataType(DataType.CANCEL);
        }
    }

    @Override
    public int getTrackHeight() {
        return 100;
    }

    @Override
    public boolean canExpandDrawables() {
        return true;
    }

    public void setStrandSpecificCoverageType(boolean b) {
        this.strandSpecificCoverageType = b;
    }

    private class RegionValue {
        int start;
        int end;
        float value;

        public RegionValue(int start, int end, float value) {
            this.start = start;
            this.end = end;
            this.value = value;
        }
    }
}

