/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.AbstractTsvLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.FileLine;
import java.util.HashMap;
import java.util.Map;

public class GtfLineParser
extends AbstractTsvLineParser {
    private Map<String, String> attributes;

    @Override
    public Region getRegion() {
        if (this.values == null) {
            return null;
        }
        long start = this.getLong(Column.START.ordinal());
        long end = this.getLong(Column.END.ordinal());
        Chromosome chr = new Chromosome(this.getString(Column.SEQNAME.ordinal()));
        String strandString = this.getString(Column.STRAND.ordinal());
        Strand strand = null;
        if ("+".equals(strandString)) {
            strand = Strand.FORWARD;
        }
        if ("-".equals(strandString)) {
            strand = Strand.REVERSE;
        }
        return new Region((Long)start, end, chr, strand);
    }

    @Override
    public boolean setLine(String line) {
        if (!line.startsWith(this.getHeaderStart())) {
            this.attributes = null;
        }
        return super.setLine(line);
    }

    public String getFeature() {
        return this.getString(Column.FEATURE.ordinal());
    }

    public String getGeneId() {
        return this.getAttribute("gene_id");
    }

    public String getTranscriptId() {
        return this.getAttribute("transcript_id");
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            this.attributes = GtfLineParser.parseAttributes(this.getString(Column.ATTRIBUTES.ordinal()));
        }
        return this.attributes.get(key);
    }

    public static Map<String, String> parseAttributes(String attributeString) {
        String[] split = attributeString.split(";");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        String key = null;
        String value = null;
        int indexOfQuotationMark = 0;
        for (int i = 0; i < split.length; ++i) {
            indexOfQuotationMark = split[i].indexOf("\"");
            key = split[i].substring(0, indexOfQuotationMark - 1).trim();
            value = split[i].substring(indexOfQuotationMark + 1, split[i].lastIndexOf("\""));
            attributeMap.put(key, value);
        }
        return attributeMap;
    }

    @Override
    public String getHeaderStart() {
        return "#";
    }

    @Override
    public FileLine getFileLine() {
        return null;
    }

    public static enum Column {
        SEQNAME("seqname"),
        SOURCE("source"),
        FEATURE("feature"),
        START("start"),
        END("end"),
        SCORE("score"),
        STRAND("strand"),
        FRAME("frame"),
        ATTRIBUTES("attributes");

        private final String name;

        private Column(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

