/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataSource;
import fi.csc.microarray.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;

public class ByteDataSource
extends DataSource {
    private RandomAccessFile raFile;
    private Long length = null;

    public ByteDataSource(DataUrl dataUrl) throws URISyntaxException, IOException {
        super(dataUrl);
        if (this.file != null) {
            this.raFile = new RandomAccessFile(this.file.getPath(), "r");
        }
    }

    public int read(long filePosition, byte[] bytes) throws IOException {
        return this.read(filePosition, bytes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(long filePosition, byte[] bytes, boolean retry) throws IOException {
        int n;
        if (this.raFile != null) {
            this.raFile.seek(filePosition);
            return this.raFile.read(bytes);
        }
        long endFilePosition = filePosition + (long)bytes.length;
        if (endFilePosition > this.length()) {
            endFilePosition = this.length();
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestProperty("Range", "bytes=" + filePosition + "-" + endFilePosition);
            int byteCount = connection.getInputStream().read(bytes);
            if (retry && (long)byteCount < endFilePosition - filePosition && byteCount != 0) {
                byte[] nextBytes = new byte[(int)(endFilePosition - filePosition - (long)byteCount)];
                int nextLength = this.read(filePosition + (long)byteCount, nextBytes);
                for (int i = 0; i < nextLength; ++i) {
                    bytes[byteCount + i] = nextBytes[i];
                }
            }
            n = byteCount;
        }
        catch (IOException e) {
            block8: {
                try {
                    if (e.getMessage().contains("HTTP") && e.getMessage().contains(" 416 ")) break block8;
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.disconnectIfPossible(connection);
                    throw throwable;
                }
            }
            IOUtils.disconnectIfPossible(connection);
            return -1;
        }
        IOUtils.disconnectIfPossible(connection);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readAll() throws IOException {
        if (this.raFile != null) {
            byte[] buf = null;
            this.raFile.seek(0L);
            buf = new byte[(int)this.raFile.length()];
            this.raFile.read(buf);
            return buf;
        }
        HttpURLConnection connection = null;
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
            in = connection.getInputStream();
            out = new ByteArrayOutputStream();
            IOUtils.copy(in, out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            IOUtils.disconnectIfPossible(connection);
        }
        if (out != null) {
            return out.toByteArray();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long length() throws IOException {
        if (this.length != null) return this.length;
        if (this.raFile != null) {
            this.length = this.raFile.length();
            return this.length;
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
            String string = connection.getHeaderField("content-length");
            if (string == null) {
                throw new IOException("content-length unavailable for " + this.url);
            }
            this.length = Long.parseLong(connection.getHeaderField("content-length"));
        }
        catch (Throwable throwable) {
            IOUtils.disconnectIfPossible(connection);
            throw throwable;
        }
        IOUtils.disconnectIfPossible(connection);
        return this.length;
    }

    public void close() {
        if (this.raFile != null) {
            try {
                this.raFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.raFile = null;
        }
    }
}

