/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BedLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedList;
import org.broad.tribble.readers.TabixReader;

public class BedTabixToRegionConversion
extends DataThread {
    private TabixDataSource dataSource;
    private BedLineParser parser = new BedLineParser(false);

    public BedTabixToRegionConversion(DataUrl repeatUrl, DataUrl repeatIndexUrl, GBrowser browser) {
        super(browser, null);
        try {
            this.dataSource = new TabixDataSource(repeatUrl, repeatIndexUrl);
            super.setDataSource(this.dataSource);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void clean() {
        this.dataSource.clean();
    }

    @Override
    protected void processDataRequest(DataRequest request) {
        TabixReader.Iterator iterator = this.dataSource.getTabixIterator(request);
        try {
            LinkedList<Feature> resultList = new LinkedList<Feature>();
            if (iterator != null) {
                String line;
                while ((line = iterator.next()) != null) {
                    this.parser.setLine(line);
                    Region region = this.parser.getRegion();
                    resultList.add(new Feature(region));
                }
            }
            super.createDataResult(new DataResult(request.getStatus(), resultList));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.getClass().getName() + " - " + this.dataSource;
    }
}

