/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;

public class Feature
implements Comparable<Feature> {
    public Region region;
    public LinkedHashMap<DataType, Object> values;

    public Feature(Region region, LinkedHashMap<DataType, Object> values) {
        this.region = region;
        this.values = values;
    }

    public Feature(Region region) {
        this.region = region;
        this.values = new LinkedHashMap();
    }

    @Override
    public int compareTo(Feature other) {
        int regionComparison = this.region.compareTo(other.region);
        if (regionComparison != 0) {
            return regionComparison;
        }
        return this.values.toString().compareTo(other.values.toString());
    }

    public int hashCode() {
        return this.region.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Feature) {
            return this.compareTo((Feature)o) == 0;
        }
        return false;
    }

    public String toString() {
        DecimalFormat FLOAT_FORMAT = new DecimalFormat("0.#########");
        String extra = "";
        for (Object value : this.values.values()) {
            if (value instanceof Float) {
                extra = extra + "\t" + FLOAT_FORMAT.format((Float)value);
                continue;
            }
            extra = extra + "\t" + value.toString();
        }
        return this.region.toString(true) + extra;
    }

    public IndexKey getIndexKey() {
        return (IndexKey)this.values.get((Object)DataType.ID);
    }

    public Object getValueObject() {
        return this.values.get((Object)DataType.VALUE);
    }
}

