/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.SynonymReplace;

public class Chromosome
implements Comparable<Chromosome> {
    public static final String CHROMOSOME_PREFIX = "chr";
    private String chr;
    private Integer intValue;
    private String chrNormalised;
    private static final SynonymReplace synonymReplace = new SynonymReplace(new SynonymReplace.Synonym[]{new SynonymReplace.Synonym("M", "MT")});
    public static final SynonymReplace ucscSynonymReplace = new SynonymReplace(new SynonymReplace.Synonym[]{new SynonymReplace.Synonym("MT", "M")});

    public Chromosome(String chr) {
        this.chr = chr;
        this.chrNormalised = Chromosome.normalise(chr, true);
        try {
            this.intValue = Integer.parseInt(this.chrNormalised);
        }
        catch (NumberFormatException e) {
            this.intValue = null;
        }
    }

    public static String normalise(String original, boolean enableSynonymReplace) {
        if (original.indexOf(".") != -1) {
            original = original.substring(0, original.indexOf("."));
        }
        String normalised = original.replace(CHROMOSOME_PREFIX, "");
        if (enableSynonymReplace) {
            normalised = synonymReplace.apply(normalised);
        }
        return normalised;
    }

    public Chromosome(Chromosome chromosome) {
        this(chromosome.chr);
    }

    public boolean equals(Object o) {
        if (o instanceof Chromosome) {
            Chromosome other = (Chromosome)o;
            return this.chrNormalised.equals(other.chrNormalised);
        }
        return false;
    }

    public int hashCode() {
        return this.chrNormalised.hashCode();
    }

    @Override
    public int compareTo(Chromosome o) {
        if (this.intValue != null && o.intValue != null) {
            return this.intValue.compareTo(o.intValue);
        }
        if (this.intValue != null && o.intValue == null) {
            return -1;
        }
        if (this.intValue == null && o.intValue != null) {
            return 1;
        }
        return this.chrNormalised.compareTo(o.chrNormalised);
    }

    public String getOriginalName() {
        return this.chr;
    }

    public String toString() {
        return this.chrNormalised;
    }

    public String toNormalisedString() {
        return this.chrNormalised;
    }

    public Chromosome clone() {
        return new Chromosome(this.chr);
    }

    public static SynonymReplace getSynonymReplace() {
        return synonymReplace;
    }
}

