/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.QueueManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RegionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataStatus;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ViewLimiter
implements RegionListener {
    private QueueManager queueManager;
    private DataThread cytobandDataSource;
    private BpCoord limit;
    private List<RegionListener> limitChangeListeners = new LinkedList<RegionListener>();

    public ViewLimiter(QueueManager queueManager, DataThread cytobandRequestHandler, GBrowserView view) {
        this.queueManager = queueManager;
        this.cytobandDataSource = cytobandRequestHandler;
        queueManager.addDataResultListener(cytobandRequestHandler, new DataResultListener(){

            @Override
            public void processDataResult(DataResult dataResult) {
                if (ViewLimiter.this.limit != null) {
                    Long previousLimit = ((ViewLimiter)ViewLimiter.this).limit.bp;
                    for (Feature regCont : dataResult.getFeatures()) {
                        BpCoord value = regCont.region.end;
                        if (!value.chr.equals(((ViewLimiter)ViewLimiter.this).limit.chr) || value.bp <= ((ViewLimiter)ViewLimiter.this).limit.bp) continue;
                        ((ViewLimiter)ViewLimiter.this).limit.bp = value.bp;
                    }
                    if (!previousLimit.equals(((ViewLimiter)ViewLimiter.this).limit.bp)) {
                        for (RegionListener listener : ViewLimiter.this.limitChangeListeners) {
                            listener.regionChanged(new Region(0L, ((ViewLimiter)ViewLimiter.this).limit.bp, ((ViewLimiter)ViewLimiter.this).limit.chr));
                        }
                    }
                }
            }
        });
        view.addRegionListener(this);
    }

    @Override
    public void regionChanged(Region bpRegion) {
        if (this.limit == null || !this.limit.chr.equals(bpRegion.start.chr)) {
            this.limit = new BpCoord(0L, bpRegion.start.chr);
            this.queueManager.addDataRequest(this.cytobandDataSource, new DataRequest(new Region(0L, Long.MAX_VALUE, bpRegion.start.chr), new HashSet<DataType>(Arrays.asList(DataType.VALUE)), new DataStatus()), null);
        }
    }

    public BpCoord getLimit() {
        if (this.limit != null && this.limit.bp != 0L) {
            return this.limit.clone();
        }
        return null;
    }

    public void addLimitChangeListener(RegionListener listener) {
        this.limitChangeListeners.add(listener);
    }

    public void removeLimitChangeListeners(RegionListener listener) {
        this.limitChangeListeners.remove(listener);
    }
}

