/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.ConcisedValueCache;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataStatus;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.SortedMap;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;

public class BamToCoverageEstimateConversion
extends DataThread {
    public static final int SAMPLE_SIZE_BP = 1000;
    private BamDataSource dataSource;
    private ConcisedValueCache cache = new ConcisedValueCache();

    public BamToCoverageEstimateConversion(BamDataSource file, GBrowser browser) {
        super(browser, file);
        this.dataSource = file;
    }

    @Override
    public void clean() {
        this.dataSource.close();
    }

    @Override
    protected void processDataRequest(DataRequest request) throws GBrowserException {
        if (request.getRequestedContents().contains((Object)DataType.CANCEL)) {
            return;
        }
        this.processCoverageEstimateRequest(request);
        if (!this.hasNewRequest()) {
            this.createBetterEstimate(request, 4);
        }
        if (!this.hasNewRequest()) {
            this.createBetterEstimate(request, 16);
        }
    }

    private void createBetterEstimate(DataRequest request, int partCount) throws GBrowserException {
        long step = this.getDataRegion().getLength() / (long)partCount;
        if (step < 1000L) {
            return;
        }
        for (long i = this.getDataRegion().start.bp.longValue(); i < this.getDataRegion().end.bp - step; i += step) {
            Region region = new Region(i, Math.min(i + step, this.getDataRegion().end.bp), this.getDataRegion().start.chr);
            DataRequest requestPart = new DataRequest(region, request.getRequestedContents(), new DataStatus(request.getStatus()));
            if (this.hasNewRequest()) {
                return;
            }
            this.processCoverageEstimateRequest(requestPart);
        }
    }

    public void processCoverageEstimateRequest(DataRequest request) throws GBrowserException {
        int step = request.getLength().intValue() / 4;
        int countHits = 0;
        int countReads = 0;
        for (long pos = request.start.bp.longValue(); pos < request.end.bp; pos += (long)step) {
            BpCoord to;
            BpCoord from = new BpCoord(pos, request.start.chr);
            SortedMap<BpCoord, ConcisedValueCache.Counts> indexedValues = this.cache.subMap(from, to = new BpCoord(pos + (long)step, request.start.chr));
            if (!indexedValues.isEmpty()) {
                ++countHits;
                this.convertCacheHits(request, step, pos, indexedValues);
                continue;
            }
            ++countReads;
            this.sampleToGetEstimateRegion(request, from, to);
        }
    }

    private void convertCacheHits(DataRequest request, int step, long pos, SortedMap<BpCoord, ConcisedValueCache.Counts> indexedValues) {
        LinkedList<Feature> responseList = new LinkedList<Feature>();
        long cachePos = 0L;
        for (BpCoord coord : indexedValues.keySet()) {
            cachePos = coord.bp;
            Region recordRegion = new Region(cachePos - 500L, cachePos + 500L, request.start.chr);
            LinkedHashMap<DataType, Object> values = new LinkedHashMap<DataType, Object>();
            values.put(DataType.COVERAGE_ESTIMATE_FORWARD, ((ConcisedValueCache.Counts)indexedValues.get((Object)coord)).forwardCount);
            values.put(DataType.COVERAGE_ESTIMATE_REVERSE, ((ConcisedValueCache.Counts)indexedValues.get((Object)coord)).reverseCount);
            responseList.add(new Feature(recordRegion, values));
        }
        super.createDataResult(new DataResult(request.getStatus(), responseList));
    }

    private void sampleToGetEstimateRegion(DataRequest request, BpCoord from, BpCoord to) throws GBrowserException {
        long t = System.currentTimeMillis();
        long stepMiddlepoint = (from.bp + to.bp) / 2L;
        long start = stepMiddlepoint - 500L;
        long end = stepMiddlepoint + 500L;
        CloseableIterator<SAMRecord> iterator = null;
        try {
            iterator = this.dataSource.query(from.chr, (int)start, (int)end);
        }
        catch (RuntimeException e) {
            throw new GBrowserException("Error in data query. Ususally this happens when a wrong index file is selected.", e);
        }
        catch (OutOfMemoryError e) {
            throw new GBrowserException("Error in data query. Ususally this happens when a wrong index file is selected. " + e.getMessage());
        }
        int countForward = 0;
        int countReverse = 0;
        int countRejected1 = 0;
        int countRejected2 = 0;
        boolean interrupted = false;
        CloseableIterator<SAMRecord> i = iterator;
        while (i.hasNext()) {
            SAMRecord record = (SAMRecord)i.next();
            if ((long)record.getAlignmentStart() >= start) {
                if ((long)record.getAlignmentEnd() <= end) {
                    if (record.getReadNegativeStrandFlag()) {
                        countReverse += record.getReadLength();
                        continue;
                    }
                    countForward += record.getReadLength();
                    continue;
                }
                ++countRejected2;
                break;
            }
            ++countRejected1;
        }
        iterator.close();
        if (!interrupted) {
            this.cache.store(new BpCoord(stepMiddlepoint, from.chr), countForward, countReverse);
            LinkedList<Feature> content = new LinkedList<Feature>();
            LinkedHashMap<DataType, Object> values = new LinkedHashMap<DataType, Object>();
            values.put(DataType.COVERAGE_ESTIMATE_FORWARD, countForward);
            values.put(DataType.COVERAGE_ESTIMATE_REVERSE, countReverse);
            content.add(new Feature(new Region(start, end, from.chr), values));
            super.createDataResult(new DataResult(request.getStatus(), content));
        }
    }

    public String toString() {
        return this.getClass().getName() + " - " + this.dataSource;
    }
}

