/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisTestBase;
import fi.csc.microarray.client.RemoteServiceAccessor;
import fi.csc.microarray.client.ServiceAccessor;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import java.util.LinkedList;
import org.testng.annotations.BeforeSuite;

public class ToolTestBase
extends AnalysisTestBase {
    protected ServiceAccessor serviceAccessor;
    protected LinkedList<ToolModule> toolModules = new LinkedList();

    public ToolTestBase(String username, String password, String configURL) {
        super(username, password, configURL);
    }

    @Override
    @BeforeSuite(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.serviceAccessor = new RemoteServiceAccessor();
        this.serviceAccessor.initialise(this.manager, this.authenticationListener);
        this.serviceAccessor.fetchDescriptions(new MicroarrayModule());
        this.toolModules.addAll(this.serviceAccessor.getModules());
    }

    protected OperationDefinition getOperationDefinition(String toolId) {
        for (ToolModule module : this.toolModules) {
            OperationDefinition tool = module.getOperationDefinition(toolId);
            if (tool == null) continue;
            return tool;
        }
        return null;
    }
}

