/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.CachingInjector;
import org.apache.camel.impl.converter.InstanceMethodFallbackTypeConverter;
import org.apache.camel.impl.converter.InstanceMethodTypeConverter;
import org.apache.camel.impl.converter.StaticMethodFallbackTypeConverter;
import org.apache.camel.impl.converter.StaticMethodTypeConverter;
import org.apache.camel.impl.converter.TypeConverterLoader;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTypeConverterLoader
implements TypeConverterLoader {
    public static final String META_INF_SERVICES = "META-INF/services/org/apache/camel/TypeConverter";
    private static final transient Log LOG = LogFactory.getLog(AnnotationTypeConverterLoader.class);
    protected PackageScanClassResolver resolver;
    protected Set<Class<?>> visitedClasses = new HashSet();
    protected Set<URL> visitedURLs = new HashSet<URL>();

    public AnnotationTypeConverterLoader(PackageScanClassResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws Exception {
        String[] packageNames = this.findPackageNames();
        Set<Class<?>> classes = this.resolver.findAnnotated(Converter.class, packageNames);
        LOG.info((Object)("Found " + packageNames.length + " packages with " + classes.size() + " @Converter classes to load"));
        for (Class<?> type : classes) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading converter class: " + ObjectHelper.name(type)));
            }
            this.loadConverterMethods(registry, type);
        }
        this.visitedClasses.clear();
        this.visitedURLs.clear();
    }

    protected String[] findPackageNames() throws IOException {
        HashSet<String> packages = new HashSet<String>();
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (ccl != null) {
            this.findPackages(packages, ccl);
        }
        this.findPackages(packages, this.getClass().getClassLoader());
        return packages.toArray(new String[packages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findPackages(Set<String> packages, ClassLoader classLoader) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(META_INF_SERVICES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (url == null || this.visitedURLs.contains(url)) continue;
            this.visitedURLs.add(url);
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Loading file META-INF/services/org/apache/camel/TypeConverter to retrieve list of packages, from url: " + url));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    this.tokenize(packages, line);
                }
            }
            finally {
                IOHelper.close(reader, null, LOG);
            }
        }
    }

    private void tokenize(Set<String> packages, String line) {
        StringTokenizer iter = new StringTokenizer(line, ",");
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            if (name.length() <= 0) continue;
            packages.add(name);
        }
    }

    protected void loadConverterMethods(TypeConverterRegistry registry, Class<?> type) {
        if (this.visitedClasses.contains(type)) {
            return;
        }
        this.visitedClasses.add(type);
        try {
            Method[] methods = type.getDeclaredMethods();
            CachingInjector<?> injector = null;
            for (Method method : methods) {
                if (ObjectHelper.hasAnnotation(method, Converter.class, true)) {
                    injector = this.handleHasConverterAnnotation(registry, type, injector, method);
                    continue;
                }
                if (!ObjectHelper.hasAnnotation(method, FallbackConverter.class, true)) continue;
                injector = this.handleHasFallbackConverterAnnotation(registry, type, injector, method);
            }
            Class<?> superclass = type.getSuperclass();
            if (superclass != null && !superclass.equals(Object.class)) {
                this.loadConverterMethods(registry, superclass);
            }
        }
        catch (NoClassDefFoundError e) {
            LOG.warn((Object)("Ignoring converter type: " + type.getCanonicalName() + " as a dependent class could not be found: " + e), (Throwable)e);
        }
    }

    private CachingInjector<?> handleHasConverterAnnotation(TypeConverterRegistry registry, Class<?> type, CachingInjector<?> injector, Method method) {
        if (this.isValidConverterMethod(method)) {
            int modifiers = method.getModifiers();
            if (Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers)) {
                LOG.warn((Object)("Ignoring bad converter on type: " + type.getCanonicalName() + " method: " + method + " as a converter method is not a public and concrete method"));
            } else {
                Class<?> toType = method.getReturnType();
                if (toType.equals(Void.class)) {
                    LOG.warn((Object)("Ignoring bad converter on type: " + type.getCanonicalName() + " method: " + method + " as a converter method returns a void method"));
                } else {
                    Class<?> fromType = method.getParameterTypes()[0];
                    if (Modifier.isStatic(modifiers)) {
                        this.registerTypeConverter(registry, method, toType, fromType, new StaticMethodTypeConverter(method));
                    } else {
                        if (injector == null) {
                            injector = new CachingInjector<Object>(registry, CastUtils.cast(type, Object.class));
                        }
                        this.registerTypeConverter(registry, method, toType, fromType, new InstanceMethodTypeConverter(injector, method, registry));
                    }
                }
            }
        } else {
            LOG.warn((Object)("Ignoring bad converter on type: " + type.getCanonicalName() + " method: " + method + " as a converter method should have one parameter"));
        }
        return injector;
    }

    private CachingInjector<?> handleHasFallbackConverterAnnotation(TypeConverterRegistry registry, Class<?> type, CachingInjector<?> injector, Method method) {
        if (this.isValidFallbackConverterMethod(method)) {
            int modifiers = method.getModifiers();
            if (Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers)) {
                LOG.warn((Object)("Ignoring bad fallback converter on type: " + type.getCanonicalName() + " method: " + method + " as a fallback converter method is not a public and concrete method"));
            } else {
                Class<?> toType = method.getReturnType();
                if (toType.equals(Void.class)) {
                    LOG.warn((Object)("Ignoring bad fallback converter on type: " + type.getCanonicalName() + " method: " + method + " as a fallback converter method returns a void method"));
                } else if (Modifier.isStatic(modifiers)) {
                    this.registerFallbackTypeConverter(registry, new StaticMethodFallbackTypeConverter(method, registry), method);
                } else {
                    if (injector == null) {
                        injector = new CachingInjector<Object>(registry, CastUtils.cast(type, Object.class));
                    }
                    this.registerFallbackTypeConverter(registry, new InstanceMethodFallbackTypeConverter(injector, method, registry), method);
                }
            }
        } else {
            LOG.warn((Object)("Ignoring bad fallback converter on type: " + type.getCanonicalName() + " method: " + method + " as a fallback converter method should have one parameter"));
        }
        return injector;
    }

    protected void registerTypeConverter(TypeConverterRegistry registry, Method method, Class<?> toType, Class<?> fromType, TypeConverter typeConverter) {
        registry.addTypeConverter(toType, fromType, typeConverter);
    }

    protected boolean isValidConverterMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes != null && (parameterTypes.length == 1 || parameterTypes.length == 2 && Exchange.class.isAssignableFrom(parameterTypes[1]));
    }

    protected void registerFallbackTypeConverter(TypeConverterRegistry registry, TypeConverter typeConverter, Method method) {
        boolean canPromote = false;
        if (method.getAnnotation(FallbackConverter.class) != null) {
            canPromote = method.getAnnotation(FallbackConverter.class).canPromote();
        }
        registry.addFallbackTypeConverter(typeConverter, canPromote);
    }

    protected boolean isValidFallbackConverterMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes != null && (parameterTypes.length == 3 || parameterTypes.length == 4 && Exchange.class.isAssignableFrom(parameterTypes[1]) && TypeConverterRegistry.class.isAssignableFrom(parameterTypes[parameterTypes.length - 1]));
    }
}

