/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineDataSource;
import java.io.IOException;
import net.sf.picard.reference.FastaSequenceIndex;
import net.sf.picard.reference.FastaSequenceIndexEntry;
import net.sf.samtools.SAMSequenceRecord;

public class ChipsterFastaSequenceIndex
extends FastaSequenceIndex
implements Iterable<FastaSequenceIndexEntry> {
    public ChipsterFastaSequenceIndex(LineDataSource indexFile) {
        this.parseIndexFile(indexFile);
    }

    private void parseIndexFile(LineDataSource indexFile) {
        try {
            int sequenceIndex = 0;
            String line = null;
            while ((line = indexFile.readLine()) != null) {
                String[] splitted = line.split("\t");
                String contig = splitted[0];
                long size = Long.valueOf(splitted[1]);
                long location = Long.valueOf(splitted[2]);
                int basesPerLine = Integer.valueOf(splitted[3]);
                int bytesPerLine = Integer.valueOf(splitted[4]);
                contig = SAMSequenceRecord.truncateSequenceName((String)contig);
                this.add(new FastaSequenceIndexEntry(contig, location, size, basesPerLine, bytesPerLine, sequenceIndex++));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

