/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class AdminAPI {
    private static final Logger logger = Logger.getLogger(AdminAPI.class);
    private static final int SERVICE_CHECK_MAX_WAITTIME = 20;
    private static final int SERVICE_CHECK_MIN_WAITTIME = 5;
    public static final int NAME_PARAMETER_INDEX = 0;
    public static final int HOST_PARAMETER_INDEX = 1;
    private MessagingListener adminListener = new MessagingListener(){
        private Lock mutex = new ReentrantLock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            this.mutex.lock();
            try {
                CommandMessage cmdMsg = (CommandMessage)msg;
                if (cmdMsg.getCommand().equals("ping-reply")) {
                    String name = cmdMsg.getParameters().get(0);
                    String host = cmdMsg.getParameters().get(1);
                    logger.debug((Object)(name + " is up"));
                    NodeStatus status = (NodeStatus)AdminAPI.this.nodeStatuses.get(name);
                    if (status != null) {
                        status.host = status.host == null ? host : status.host + ", " + host;
                        ++status.count;
                        if (status.count >= status.requiredCount) {
                            status.status = NodeStatus.Status.UP;
                        }
                        AdminAPI.this.notifyListener();
                    }
                }
            }
            finally {
                this.mutex.unlock();
            }
        }
    };
    private MessagingTopic adminTopic;
    private Map<String, NodeStatus> nodeStatuses = new LinkedHashMap<String, NodeStatus>();
    private AdminAPILIstener listener;
    private String errorStatus = "";

    public AdminAPI(MessagingTopic adminTopic, AdminAPILIstener listener) throws JMSException {
        this.listener = listener;
        this.adminTopic = adminTopic;
        adminTopic.setListener(this.adminListener);
        this.nodeStatuses.put("authenticator", new NodeStatus("authenticator"));
        this.nodeStatuses.put("analyser", new NodeStatus("analyser"));
        this.nodeStatuses.put("filebroker", new NodeStatus("filebroker"));
        this.nodeStatuses.put("manager", new NodeStatus("manager"));
        this.nodeStatuses.put("client", new NodeStatus("client"));
    }

    public void setRequiredCountFor(String nodeName, int requiredCount) {
        this.nodeStatuses.get((Object)nodeName).requiredCount = requiredCount;
    }

    public String getErrorStatus() {
        return this.errorStatus;
    }

    public boolean areAllServicesUp(boolean fastCheck) throws InterruptedException, JMSException {
        this.ping();
        boolean allServicesUp = false;
        int seconds = 0;
        while (true) {
            Thread.sleep(1024L);
            allServicesUp = this.areAlreadyUp();
            if (allServicesUp && (fastCheck || seconds >= 5) || seconds >= 20) break;
            ++seconds;
        }
        for (NodeStatus nodeStatus : this.nodeStatuses.values()) {
            if (nodeStatus.status != NodeStatus.Status.UNKNOWN) continue;
            nodeStatus.status = NodeStatus.Status.DOWN;
        }
        return allServicesUp;
    }

    public String generateStatusReport() {
        String report = "";
        for (NodeStatus status : this.nodeStatuses.values()) {
            report = report + status.name + ": count " + status.count + ", host(s) " + status.host + "\n";
        }
        return report;
    }

    private boolean areAlreadyUp() {
        this.errorStatus = "";
        boolean areUp = true;
        if (this.nodeStatuses.get((Object)"filebroker").status != NodeStatus.Status.UP) {
            this.errorStatus = this.errorStatus + " filebroker(s) not up ";
            areUp = false;
        }
        if (this.nodeStatuses.get((Object)"analyser").status != NodeStatus.Status.UP) {
            this.errorStatus = this.errorStatus + " analyser(s) not up ";
            areUp = false;
        }
        if (this.nodeStatuses.get((Object)"authenticator").status != NodeStatus.Status.UP) {
            this.errorStatus = this.errorStatus + " authenticator(s) not up ";
            areUp = false;
        }
        return areUp;
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.statusUpdated(this.nodeStatuses);
        }
    }

    private void ping() throws JMSException {
        CommandMessage pingMsg = new CommandMessage("ping");
        this.adminTopic.sendMessage(pingMsg);
    }

    public static class NodeStatus {
        public final String name;
        public String host = null;
        public Status status = Status.UNKNOWN;
        public int count = 0;
        public int requiredCount = 0;

        public NodeStatus(String name) {
            this.name = name;
        }

        public NodeStatus(String name, int requiredCount) {
            this(name);
            this.requiredCount = requiredCount;
        }

        public static enum Status {
            UP,
            DOWN,
            UNKNOWN;

        }
    }

    public static interface AdminAPILIstener {
        public void statusUpdated(Map<String, NodeStatus> var1);
    }
}

