/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.util;

import fi.csc.microarray.client.visualisation.methods.gbrowser.util.ChromosomeNormaliser;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.BuildBamIndex;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.seekablestream.SeekableBufferedStream;
import net.sf.samtools.seekablestream.SeekableFileStream;
import net.sf.samtools.seekablestream.SeekableHTTPStream;
import net.sf.samtools.seekablestream.SeekableStream;
import org.broad.tribble.readers.TabixReader;

public class SamBamUtils {
    private SamBamUtilStateListener stateListener;
    private ChromosomeNormaliser chromosomeNormaliser;

    public SamBamUtils() {
    }

    public SamBamUtils(SamBamUtilStateListener stateListener, ChromosomeNormaliser chromosomeNormaliser) {
        this.stateListener = stateListener;
        this.chromosomeNormaliser = chromosomeNormaliser;
    }

    private void updateState(String state, double percentage) {
        if (this.stateListener != null) {
            this.stateListener.stateChanged(new SamBamUtilState(state, percentage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertElandToSortedBam(File elandFile, File bamFile) throws IOException {
        BufferedReader in = null;
        SAMFileWriter writer = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(elandFile)));
            SAMFileHeader header = new SAMFileHeader();
            header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
            writer = new SAMFileWriterFactory().makeBAMWriter(header, false, bamFile);
            String line = in.readLine();
            while (line != null) {
                String[] fields = line.split("\t");
                SAMRecord alignment = new SAMRecord(header);
                alignment.setReadName(fields[0]);
                alignment.setReadBases(fields[1].getBytes());
                alignment.setAlignmentStart(Integer.parseInt(fields[7]));
                alignment.setReadNegativeStrandFlag("R".equals(fields[8]));
                alignment.setReferenceName(fields[6]);
                writer.addAlignment(alignment);
                line = in.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(in);
            SamBamUtils.closeIfPossible(writer);
            throw throwable;
        }
        IOUtils.closeIfPossible(in);
        SamBamUtils.closeIfPossible(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sortSamBam(File samBamFile, File sortedBamFile) {
        SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.SILENT);
        SAMFileReader reader = new SAMFileReader(IoUtil.openFileForReading((File)samBamFile));
        SAMFileWriter writer = null;
        try {
            reader.getFileHeader().setSortOrder(SAMFileHeader.SortOrder.coordinate);
            writer = new SAMFileWriterFactory().makeBAMWriter(reader.getFileHeader(), false, sortedBamFile);
            SAMRecordIterator iterator = reader.iterator();
            while (iterator.hasNext()) {
                writer.addAlignment((SAMRecord)iterator.next());
            }
        }
        catch (Throwable throwable) {
            SamBamUtils.closeIfPossible(reader);
            SamBamUtils.closeIfPossible(writer);
            throw throwable;
        }
        SamBamUtils.closeIfPossible(reader);
        SamBamUtils.closeIfPossible(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normaliseBam(File bamFile, File normalisedBamFile) {
        SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.SILENT);
        SAMFileReader reader = new SAMFileReader(IoUtil.openFileForReading((File)bamFile));
        SAMFileWriter writer = null;
        try {
            SAMFileHeader normalisedHeader = reader.getFileHeader();
            SAMSequenceDictionary normalisedDictionary = new SAMSequenceDictionary();
            for (SAMSequenceRecord sequenceRecord : normalisedHeader.getSequenceDictionary().getSequences()) {
                String sequenceName = this.chromosomeNormaliser.normaliseChromosome(sequenceRecord.getSequenceName());
                normalisedDictionary.addSequence(new SAMSequenceRecord(sequenceName, sequenceRecord.getSequenceLength()));
            }
            normalisedHeader.setSequenceDictionary(normalisedDictionary);
            writer = new SAMFileWriterFactory().makeBAMWriter(normalisedHeader, true, normalisedBamFile);
            for (SAMRecord rec : reader) {
                rec.setHeader(normalisedHeader);
                writer.addAlignment(rec);
            }
        }
        catch (Throwable throwable) {
            SamBamUtils.closeIfPossible(reader);
            SamBamUtils.closeIfPossible(writer);
            throw throwable;
        }
        SamBamUtils.closeIfPossible(reader);
        SamBamUtils.closeIfPossible(writer);
    }

    public void indexBam(File bamFile, File baiFile) {
        SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.SILENT);
        BuildBamIndex.createIndex((SAMFileReader)new SAMFileReader(IoUtil.openFileForReading((File)bamFile)), (File)baiFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preprocessEland(File elandFile, File preprocessedBamFile, File baiFile) throws IOException {
        File sortedTempBamFile = File.createTempFile("converted", "bam");
        try {
            SamBamUtils.convertElandToSortedBam(elandFile, sortedTempBamFile);
            this.normaliseBam(sortedTempBamFile, preprocessedBamFile);
            sortedTempBamFile.delete();
            this.indexBam(preprocessedBamFile, baiFile);
        }
        finally {
            sortedTempBamFile.delete();
        }
    }

    public void preprocessSamBam(File samBamFile, File preprocessedBamFile, File baiFile) throws IOException {
        this.updateState("sorting", 0.0);
        File sortedTempBamFile = File.createTempFile("sorted", "bam");
        SamBamUtils.sortSamBam(samBamFile, sortedTempBamFile);
        this.updateState("normalising", 33.3);
        this.normaliseBam(sortedTempBamFile, preprocessedBamFile);
        sortedTempBamFile.delete();
        this.updateState("indexing", 66.0);
        this.indexBam(preprocessedBamFile, baiFile);
        this.updateState("done", 100.0);
    }

    public static List<String> readChromosomeNames(URL bam, URL index) throws FileNotFoundException, URISyntaxException {
        SAMFileReader reader = SamBamUtils.getSAMReader(bam, index);
        LinkedList<String> chromosomes = new LinkedList<String>();
        for (SAMSequenceRecord record : reader.getFileHeader().getSequenceDictionary().getSequences()) {
            chromosomes.add(record.getSequenceName());
        }
        SamBamUtils.closeIfPossible(reader);
        return chromosomes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAMFileReader getSAMReader(URL bam, URL index) throws FileNotFoundException, URISyntaxException {
        SAMFileReader reader = null;
        Object bamStream = null;
        Object indexStream = null;
        try {
            bamStream = "file".equals(bam.getProtocol()) ? new SeekableFileStream(new File(bam.toURI())) : new SeekableHTTPStream(bam);
            SeekableBufferedStream bamBufferedStream = new SeekableBufferedStream((SeekableStream)bamStream){

                public String getSource() {
                    return super.getSource() + "_fake-source.bam";
                }
            };
            indexStream = "file".equals(index.getProtocol()) ? new SeekableFileStream(new File(index.toURI())) : new SeekableHTTPStream(index);
            SeekableBufferedStream indexBufferedStream = new SeekableBufferedStream((SeekableStream)indexStream);
            SAMFileReader sAMFileReader = new SAMFileReader((SeekableStream)bamBufferedStream, (SeekableStream)indexBufferedStream, false);
            return sAMFileReader;
        }
        finally {
            SamBamUtils.closeIfPossible(reader);
        }
    }

    private static void closeIfPossible(SAMFileWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(SAMFileReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(TabixReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isSamBamExtension(String extension) {
        if (extension == null) {
            return false;
        }
        return "sam".equals(extension = extension.toLowerCase()) || "bam".equals(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printSamBam(InputStream samBamStream, int maxRecords) throws IOException {
        SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.SILENT);
        SAMFileReader in = new SAMFileReader(samBamStream);
        SAMFileHeader header = in.getFileHeader();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMWriter(header, true, (OutputStream)buffer);
        int i = 0;
        try {
            for (SAMRecord rec : in) {
                if (i > maxRecords) {
                    break;
                }
                out.addAlignment(rec);
                ++i;
            }
        }
        finally {
            SamBamUtils.closeIfPossible(out);
        }
        if (i > maxRecords) {
            buffer.write("SAM/BAM too long for viewing, truncated here!\n".getBytes());
        }
        return buffer.toString();
    }

    public class SamBamUtilState {
        private String state;
        private double percentage;

        public SamBamUtilState(String state, double percentage) {
            this.state = state;
            this.percentage = percentage;
        }

        public String getState() {
            return this.state;
        }

        public double getPercentage() {
            return this.percentage;
        }
    }

    public static interface SamBamUtilStateListener {
        public void stateChanged(SamBamUtilState var1);
    }
}

