/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.util;

import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.CoverageTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.BaseStorage;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class CoverageStorage {
    private static final long AVERAGE_LIMIT = 2000L;
    private TreeMap<BpCoord, BaseStorage.Base> forwardBases = new TreeMap();
    private TreeMap<BpCoord, BaseStorage.Base> reverseBases = new TreeMap();
    private TreeMap<Region, Float> forwardAverages = new TreeMap();
    private TreeMap<Region, Float> reverseAverages = new TreeMap();
    private boolean totalBasesNeedsRefresh;
    private boolean totalAveragesNeedsRefresh;
    private TreeMap<BpCoord, BaseStorage.Base> totalBases;
    private TreeMap<Region, Float> totalAverages;

    public void addAverages(DataResult dataResult, Region filterRegion) {
        DataRequest request = dataResult.getRequest();
        if (request != null && request.getRequestedContents().contains((Object)DataType.COVERAGE_AVERAGE)) {
            CoverageTool.convertRegionContentListToFloatList(dataResult.getContents(), this.forwardAverages, this.reverseAverages);
            this.filterAverages(this.forwardAverages, filterRegion);
            this.filterAverages(this.reverseAverages, filterRegion);
            this.totalAveragesNeedsRefresh = true;
        }
    }

    public void addBaseCoverage(DataResult dataResult, Region filterRegion) {
        DataRequest request = dataResult.getRequest();
        if (request != null && request.getRequestedContents().contains((Object)DataType.COVERAGE)) {
            CoverageTool.convertRegionContentListToBaseList(dataResult.getContents(), this.forwardBases, this.reverseBases);
            this.filterBases(this.forwardBases, filterRegion);
            this.filterBases(this.reverseBases, filterRegion);
            this.totalBasesNeedsRefresh = true;
        }
    }

    private void filterBases(TreeMap<BpCoord, BaseStorage.Base> bases, Region filterRegion) {
        Iterator<BpCoord> iterator = bases.keySet().iterator();
        while (iterator.hasNext()) {
            BpCoord region = iterator.next();
            if (filterRegion.contains(region)) continue;
            iterator.remove();
        }
    }

    private void filterAverages(TreeMap<Region, Float> averages, Region filterRegion) {
        Iterator<Region> iterator = averages.keySet().iterator();
        while (iterator.hasNext()) {
            Region region = iterator.next();
            if (filterRegion.intersects(region)) continue;
            iterator.remove();
        }
    }

    public TreeMap<BpCoord, BaseStorage.Base> getTotalBases() {
        if (this.totalBases == null || this.totalBasesNeedsRefresh) {
            Iterator<Map.Entry<BpCoord, BaseStorage.Base>> forward = this.forwardBases.entrySet().iterator();
            Iterator<Map.Entry<BpCoord, BaseStorage.Base>> reverse = this.reverseBases.entrySet().iterator();
            this.totalBases = CoverageTool.getTotalBases(forward, reverse);
            this.totalBasesNeedsRefresh = false;
        }
        return this.totalBases;
    }

    public TreeMap<Region, Float> getTotalAverageCoverage() {
        if (this.totalAverages == null || this.totalAveragesNeedsRefresh) {
            Iterator<Map.Entry<Region, Float>> forward = this.forwardAverages.entrySet().iterator();
            Iterator<Map.Entry<Region, Float>> reverse = this.reverseAverages.entrySet().iterator();
            this.totalAverages = CoverageTool.getTotalAverageCoverage(forward, reverse);
            this.totalAveragesNeedsRefresh = false;
        }
        return this.totalAverages;
    }

    public BaseStorage.Base getBase(BpCoord location, Strand strand) {
        if (this.totalBases == null || this.totalBasesNeedsRefresh) {
            throw new IllegalStateException("totalBases is not initialized");
        }
        if (strand == Strand.FORWARD) {
            return this.forwardBases.get(location);
        }
        if (strand == Strand.REVERSE) {
            return this.reverseBases.get(location);
        }
        if (strand == Strand.BOTH) {
            return this.totalBases.get(location);
        }
        return null;
    }

    public Float getAverage(Region region, Strand strand) {
        if (this.totalAverages == null || this.totalAveragesNeedsRefresh) {
            throw new IllegalStateException("totalAverages is not initialized");
        }
        if (strand == Strand.FORWARD) {
            return this.forwardAverages.get(region);
        }
        if (strand == Strand.REVERSE) {
            return this.reverseAverages.get(region);
        }
        if (strand == Strand.BOTH) {
            return this.totalAverages.get(region);
        }
        return null;
    }

    public boolean isAverage(Region viewRegion) {
        return viewRegion.getLength() >= 2000L;
    }
}

