/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Sequence;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ReferenceSequenceTrack
extends Track {
    private TreeMap<BpCoord, String> reads = new TreeMap();

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.reads != null) {
            Iterator<Map.Entry<BpCoord, String>> iter = this.reads.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<BpCoord, String> read = iter.next();
                if (!this.getView().requestContains(read.getKey())) {
                    iter.remove();
                    continue;
                }
                String seq = read.getValue();
                drawables.addAll(this.getSeqDrawable(read.getKey(), seq, 10));
                drawables.addAll(this.getSeqDrawable(read.getKey(), Sequence.complement(seq), 0));
            }
        }
        return drawables;
    }

    private Collection<Drawable> getSeqDrawable(BpCoord pos, String seq, int yOffset) {
        Rectangle rect = new Rectangle();
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        rect.x = this.getView().bpToTrack(pos);
        rect.width = this.getView().bpToTrack(new BpCoord(pos.bp + 1L, pos.chr)) - rect.x;
        rect.y = 1 + yOffset;
        rect.height = 10;
        int CHAR_WIDTH = 7;
        float x = rect.x;
        float increment = (float)rect.width / (float)seq.length();
        char letter = seq.charAt(0);
        Color bg = Color.white;
        if (letter == 'A' || letter == 'a') {
            bg = GBrowserConstants.charColors[0];
        } else if (letter == 'C' || letter == 'c') {
            bg = GBrowserConstants.charColors[1];
        } else if (letter == 'G' || letter == 'g') {
            bg = GBrowserConstants.charColors[2];
        } else if (letter == 'T' || letter == 't') {
            bg = GBrowserConstants.charColors[3];
        } else if (letter == 'N' || letter == 'n') {
            bg = Color.white;
        }
        float nextX = x + increment;
        drawables.add(new RectDrawable(Math.round(x), rect.y - 1, Math.round(nextX) - Math.round(x), 10, bg, null));
        if (rect.width > seq.length() * 7) {
            drawables.add(new TextDrawable((int)x + 1, rect.y + 9, "" + Character.toUpperCase(letter), Color.DARK_GRAY));
        }
        x = nextX;
        return drawables;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        for (RegionContent rc : dataResult.getContents()) {
            String seq = (String)rc.values.get((Object)DataType.SEQUENCE);
            if (seq == null) continue;
            for (int i = 0; i < seq.length(); ++i) {
                BpCoord bp = new BpCoord(rc.region.start.bp + (long)i, rc.region.start.chr);
                this.reads.put(bp, "" + seq.charAt(i));
            }
        }
    }

    @Override
    public int getHeight() {
        return 20;
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.SEQUENCE);
    }

    @Override
    public String getName() {
        return "Reads";
    }
}

