/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class PeakTrack
extends Track {
    private static final int MIN_VISIBLE_PEAK_SIZE = 5;
    private static final int PEAK_SYMBOL_HEIGHT = 10;
    private Collection<RegionContent> peaks = new TreeSet<RegionContent>();
    private Color color;

    public PeakTrack(Color color) {
        this.color = color;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.peaks != null) {
            Iterator<RegionContent> iter = this.peaks.iterator();
            while (iter.hasNext()) {
                RegionContent peak = iter.next();
                if (!this.getView().requestIntersects(peak.region)) {
                    iter.remove();
                    continue;
                }
                this.createDrawable(peak.region.start, peak.region.end, 10, this.color, drawables);
            }
        }
        return drawables;
    }

    private void createDrawable(BpCoord startBp, BpCoord endBp, int height, Color c, Collection<Drawable> drawables) {
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp);
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        if (rect.width < 5) {
            rect.width = 5;
        }
        rect.y = this.getHeight() / 2;
        rect.height = height;
        drawables.add(new RectDrawable(rect, c, c.darker()));
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        this.peaks.addAll(dataResult.getContents());
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.CHROMOSOME);
        this.addDataType(DataType.START);
        this.addDataType(DataType.END);
    }

    @Override
    public int getHeight() {
        return 20;
    }
}

