/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.QueueManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataStatus;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import javax.swing.SwingUtilities;

public abstract class DataThread {
    private LinkedBlockingDeque<DataRequest> dataRequestQueue;
    protected QueueManager queueManager;
    protected Thread thread;
    private boolean poison = false;
    private Region dataRegion;
    private GBrowser browser;

    public DataThread(GBrowser browser) {
        this.browser = browser;
    }

    public void runThread() {
        this.thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void run() {
                while (!DataThread.this.poison) {
                    try {
                        boolean processRequest;
                        DataThread.this.reportQueueSize(false);
                        DataRequest dataRequest = (DataRequest)DataThread.this.dataRequestQueue.takeFirst();
                        if (dataRequest == null) continue;
                        DataThread.this.reportQueueSize(true);
                        1 var3_4 = this;
                        synchronized (var3_4) {
                            processRequest = DataThread.this.dataRegion == null || dataRequest.getStatus().poison || dataRequest instanceof GeneRequest || DataThread.this.dataRegion != null && DataThread.this.dataRegion.intersects(dataRequest);
                        }
                        if (!processRequest || DataThread.this.checkPoison(dataRequest)) continue;
                        try {
                            DataThread.this.processDataRequest(dataRequest);
                        }
                        catch (GBrowserException e) {
                            DataThread.this.reportException(e);
                            DataThread.this.poison = true;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                DataThread.this.clean();
            }
        };
        this.thread.setDaemon(true);
        this.thread.setName(this.getClass().getSimpleName());
        this.thread.start();
    }

    public void clean() {
    }

    private boolean checkPoison(DataRequest dataRequest) {
        if (dataRequest.getStatus().poison) {
            this.queueManager = null;
            this.poison = true;
            this.clean();
        }
        return dataRequest.getStatus().poison;
    }

    protected abstract void processDataRequest(DataRequest var1) throws GBrowserException;

    public void createDataResult(final DataResult dataResult) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DataThread.this.queueManager != null) {
                    DataThread.this.queueManager.processDataResult(dataResult);
                }
            }
        });
    }

    public void setQueue(Queue<DataRequest> queue) {
        this.dataRequestQueue = (LinkedBlockingDeque)queue;
    }

    public boolean hasNewRequest() {
        return this.dataRequestQueue.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataRegion(Region dataRegion) {
        DataThread dataThread = this;
        synchronized (dataThread) {
            if (dataRegion != null && dataRegion.start != null && dataRegion.end != null) {
                Region region;
                this.dataRegion = region = new Region((long)dataRegion.start.bp, (long)dataRegion.end.bp, new Chromosome(dataRegion.start.chr));
            }
        }
    }

    public Region getDataRegion() {
        return this.dataRegion;
    }

    private void reportQueueSize(boolean increaseByOne) {
        DataStatus status = new DataStatus();
        status.setDataThread(this);
        status.setDataRequestCount(this.dataRequestQueue.size() + (increaseByOne ? 1 : 0));
        LinkedList<RegionContent> emptyList = new LinkedList<RegionContent>();
        this.createDataResult(new DataResult(status, emptyList));
    }

    public void setQueueManager(QueueManager queueManager) {
        this.queueManager = queueManager;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isAlive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive();
    }

    private void reportException(final Exception e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataThread.this.browser.reportException(e);
            }
        });
    }
}

