/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.CnaRow;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BinarySearchIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CnaLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.Index;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;

public class CnaConversion
extends DataThread {
    private Index index;
    private CnaLineParser parser;
    private LinkedList<String> sampleNames;

    public CnaConversion(RandomAccessLineDataSource file, final GBrowser browser) {
        super(browser);
        try {
            file.setLineReaderPosition(0L);
            String header = file.getNextLine();
            this.parser = new CnaLineParser();
            this.parser.setLine(header);
            this.sampleNames = this.parser.getSampleNames();
            this.index = new BinarySearchIndex(file, this.parser);
        }
        catch (UnsortedDataException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    browser.showDialog("Unsorted data", e.getMessage(), null, true, false, true, true);
                }
            });
            this.index = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GBrowserException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void processDataRequest(DataRequest request) {
        if (this.index == null) {
            return;
        }
        long start = request.start.bp;
        long end = request.end.bp;
        start = 1L;
        Region requestRegion = new Region(start, end, request.start.chr);
        TreeMap<IndexKey, String> lines = null;
        try {
            lines = this.index.getFileLines(new DataRequest(requestRegion, request.getRequestedContents(), request.getStatus()));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GBrowserException e) {
            e.printStackTrace();
        }
        LinkedList<RegionContent> list = new LinkedList<RegionContent>();
        for (Map.Entry lineEntry : lines.entrySet()) {
            Float lossFreq;
            this.parser.setLine((String)lineEntry.getValue());
            Region region = this.parser.getRegion();
            if (!region.intersects(request)) continue;
            CnaRow row = new CnaRow();
            row.setRegion(region);
            Float gainFreq = this.parser.getGainFreq();
            if (gainFreq != null) {
                row.setGainFreg(gainFreq);
            }
            if ((lossFreq = this.parser.getLossFreq()) != null) {
                row.setLossFreg(this.parser.getLossFreq());
            }
            LinkedList<String> sampleNames = this.parser.getSampleNames();
            LinkedList<Float> flagValues = this.parser.getFlagValues();
            LinkedList<Float> logRatioValues = this.parser.getLogRatioValues();
            LinkedList<CnaRow.Sample> samples = new LinkedList<CnaRow.Sample>();
            for (int i = 0; i < sampleNames.size(); ++i) {
                CnaRow.Sample sample = new CnaRow.Sample();
                sample.setName((String)sampleNames.get(i));
                if (flagValues.size() > 0) {
                    sample.setFlag((Float)flagValues.get(i));
                }
                sample.setLogRatio((Float)logRatioValues.get(i));
                samples.add(sample);
            }
            row.setSamples(samples);
            IndexKey id = (IndexKey)lineEntry.getKey();
            LinkedHashMap<DataType, Object> valueMap = new LinkedHashMap<DataType, Object>();
            valueMap.put(DataType.ID, id);
            valueMap.put(DataType.VALUE, row);
            valueMap.put(DataType.LOSS, row.getLossFreg());
            valueMap.put(DataType.GAIN, row.getGainFreg());
            valueMap.put(DataType.FLOAT_LIST, logRatioValues);
            RegionContent regionContent = new RegionContent(region, valueMap);
            list.add(regionContent);
        }
        super.createDataResult(new DataResult(request.getStatus(), list));
    }

    public LinkedList<String> getSampleNames() {
        return this.sampleNames;
    }
}

