/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BinarySearchIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.GtfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.TreeSet;

public class ChromosomeBinarySearch {
    private static final long ITERATIVE_SEARCH_LIMIT = 8192L;
    private RandomAccessLineDataSource file;
    private TreeSet<Chromosome> chrSet = new TreeSet();
    private LineParser parser;

    public ChromosomeBinarySearch(URL url, LineParser parser) throws IOException, GBrowserException, URISyntaxException, UnsortedDataException {
        this.file = new RandomAccessLineDataSource(url);
        this.parser = parser;
    }

    public TreeSet<Chromosome> getChromosomes() throws IOException, GBrowserException, UnsortedDataException {
        BinarySearchIndex index = new BinarySearchIndex(this.file, this.parser);
        index.checkSorting();
        this.searchChromosomeChange(0L, Long.MAX_VALUE, null, null);
        return this.chrSet;
    }

    private Chromosome getChr(long pos) throws IOException, GBrowserException {
        if (pos != 0L) {
            this.file.setLineReaderPosition(pos);
            this.file.getNextLine();
        } else {
            this.file.setLineReaderPosition(0L);
        }
        String line = this.file.getNextLine();
        if (line != null) {
            this.parser.setLine(line);
            if (this.parser.isContentLine()) {
                return this.parser.getRegion().start.chr;
            }
            return this.getChr(pos + (long)line.length() + 1L);
        }
        return null;
    }

    private void searchChromosomeChange(long pos1, long pos2, Chromosome chr1, Chromosome chr2) throws IOException, GBrowserException {
        if (pos1 >= pos2) {
            return;
        }
        if (chr1 == null) {
            chr1 = this.getChr(pos1);
        }
        if (pos2 == Long.MAX_VALUE) {
            String lastLine = this.file.getLastLine();
            this.parser.setLine(lastLine);
            chr2 = this.parser.getRegion().start.chr;
            pos2 = this.file.length() - (long)lastLine.length() - 1L;
        } else if (chr2 == null) {
            chr2 = this.getChr(pos2);
        }
        this.chrSet.add(chr1);
        this.chrSet.add(chr2);
        if (!chr1.equals(chr2)) {
            if (pos2 - pos1 < 8192L) {
                this.linearSearch(pos1, pos2, chr1, chr2);
            } else {
                long centerPos = (pos1 + pos2) / 2L;
                Chromosome centerChr = this.getChr(centerPos);
                this.searchChromosomeChange(pos1, centerPos, chr1, centerChr);
                this.searchChromosomeChange(centerPos, pos2, centerChr, chr2);
            }
        }
    }

    private void linearSearch(long pos1, long pos2, Chromosome chr1, Chromosome chr2) throws IOException, GBrowserException {
        long pos = pos1;
        this.file.setLineReaderPosition(pos);
        if (pos != 0L) {
            pos += (long)(this.file.getNextLine().length() + 1);
        }
        while (pos < pos2) {
            String line = this.file.getNextLine();
            this.parser.setLine(line);
            if (!this.parser.isContentLine()) continue;
            Chromosome searchChr = this.parser.getRegion().start.chr;
            pos += (long)(line.length() + 1);
            if (chr1.equals(searchChr)) continue;
            this.chrSet.add(searchChr);
            if (!chr2.equals(searchChr)) continue;
            break;
        }
    }

    public static void main(String[] args) throws IOException, GBrowserException, URISyntaxException {
        String fileString = System.getProperty("user.home") + "/chipster/Homo_sapiens.GRCh37.69-sort.gtf";
        URL fileUrl = new File(fileString).toURI().toURL();
        ChromosomeBinarySearch.printTestTime(fileUrl, "File: ");
        URL httpUrl = new URL("http://chipster-filebroker.csc.fi:7060/public/annotations/tmp/Homo_sapiens.GRCh37.69-sort.gtf");
        ChromosomeBinarySearch.printTestTime(httpUrl, "Http: ");
    }

    private static void printTestTime(URL url, String description) throws IOException, GBrowserException, URISyntaxException {
        ChromosomeBinarySearch index = new ChromosomeBinarySearch(url, new GtfLineParser());
        long t = System.currentTimeMillis();
        TreeSet<Chromosome> chrs = index.getChromosomes();
        System.out.println(description + (System.currentTimeMillis() - t) + " ms");
    }
}

