/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.ToolCategory;
import java.util.LinkedList;
import java.util.List;

public class ToolModule {
    private List<ToolCategory> visibleCategories = new LinkedList<ToolCategory>();
    private List<ToolCategory> hiddenCategories = new LinkedList<ToolCategory>();
    private String moduleName;

    public String getModuleName() {
        return this.moduleName;
    }

    public ToolModule(String moduleName) {
        this.moduleName = moduleName;
    }

    public boolean isVisible() {
        return !this.visibleCategories.isEmpty();
    }

    public List<ToolCategory> getVisibleCategories() {
        return this.visibleCategories;
    }

    public List<ToolCategory> getHiddenCategories() {
        return this.hiddenCategories;
    }

    public void addVisibleToolCategory(ToolCategory category) {
        this.visibleCategories.add(category);
    }

    public void addHiddenToolCategory(ToolCategory category) {
        this.hiddenCategories.add(category);
    }

    public OperationDefinition getOperationDefinition(String toolId) {
        for (List categories : new List[]{this.visibleCategories, this.hiddenCategories}) {
            for (ToolCategory category : categories) {
                for (OperationDefinition tool : category.getToolList()) {
                    if (!tool.getID().equals(toolId)) continue;
                    return tool;
                }
            }
        }
        return null;
    }

    public OperationDefinition getOperationDefinition(String toolId, String categoryName) {
        ToolCategory preferredCategory = this.getCategory(categoryName);
        if (preferredCategory != null) {
            for (OperationDefinition tool : preferredCategory.getToolList()) {
                if (!tool.getID().equals(toolId)) continue;
                return tool;
            }
        }
        return null;
    }

    private ToolCategory getCategory(String categoryName) {
        for (ToolCategory category : this.visibleCategories) {
            if (!category.getName().equals(categoryName)) continue;
            return category;
        }
        for (ToolCategory category : this.hiddenCategories) {
            if (!category.getName().equals(categoryName)) continue;
            return category;
        }
        return null;
    }
}

