/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.web.adminweb.data;

import com.vaadin.data.util.BeanItemContainer;
import fi.csc.chipster.web.adminweb.data.StorageEntry;
import fi.csc.chipster.web.adminweb.ui.StorageView;
import fi.csc.chipster.web.adminweb.util.RandomUtil;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;

public class StorageEntryContainer
extends BeanItemContainer<StorageEntry>
implements Serializable {
    public static final String USERNAME = "username";
    public static final String NAME = "name";
    public static final String SIZE = "size";
    public static final String DATE = "date";
    public static final String DELETE_LINK = "deleteLink";
    public static final Object[] NATURAL_COL_ORDER = new String[]{"username", "name", "size", "date", "deleteLink"};
    public static final String[] COL_HEADERS_ENGLISH = new String[]{"Username", "Session name", "Size", "Date", " "};

    public StorageEntryContainer() throws InstantiationException, IllegalAccessException {
        super(StorageEntry.class);
    }

    public void update(final StorageView view) {
        ExecutorService execService = Executors.newCachedThreadPool();
        execService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (view.getEntryTable().getUI() != null) {
                    Lock tableLock = view.getEntryTable().getUI().getSession().getLockInstance();
                    tableLock.lock();
                    try {
                        int COUNT = 300;
                        StorageEntryContainer.this.removeAllItems();
                        Random rnd = new Random();
                        for (int i = 0; i < 300; ++i) {
                            StorageEntry entry = new StorageEntry();
                            entry.setDate(RandomUtil.getRandomDate(rnd, 2011));
                            entry.setUsername(RandomUtil.getRandomUserName(rnd));
                            entry.setSize(Math.abs((long)rnd.nextInt(rnd.nextInt(9000000)) * 1000L));
                            entry.setName(RandomUtil.getRandomSessionName(rnd));
                            StorageEntryContainer.this.addBean(entry);
                        }
                    }
                    finally {
                        tableLock.unlock();
                    }
                }
                view.entryUpdateDone();
            }
        });
    }

    public void showUser(String username) {
        this.removeContainerFilters(USERNAME);
        if (username != null) {
            this.addContainerFilter(USERNAME, username, false, true);
        }
    }
}

