/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JCheckBox;
import org.emboss.jemboss.gui.form.JembossComboPopup;
import org.emboss.jemboss.gui.form.LabelTextBox;
import org.emboss.jemboss.gui.form.PlafMacros;
import org.emboss.jemboss.parser.ParseAcd;

public class ReportFormat {
    private static String[] rpt = new String[]{"embl", "genbank", "gff", "pir", "swiss", "listfile", "dbmotif", "diffseq", "excel", "feattable", "motif", "nametable", "regions", "seqtable", "simple", "srs", "table", "tagseq"};
    private JembossComboPopup cp;
    private JCheckBox raccshow = new JCheckBox();
    private JCheckBox rdesshow = new JCheckBox();
    private JCheckBox rusashow = new JCheckBox();
    private String def;

    public ReportFormat(ParseAcd parseAcd, int n) {
        this.cp = new JembossComboPopup(ReportFormat.getReportFormats());
        int n2 = parseAcd.getNumofParams(n);
        for (int i = 0; i < n2; ++i) {
            if (!parseAcd.getParameterAttribute(n, i).equals("rformat")) continue;
            this.def = parseAcd.getParamValueStr(n, i);
            this.cp.setSelectedItem(parseAcd.getParamValueStr(n, i));
        }
        Dimension dimension = this.cp.getPreferredSize();
        dimension = new Dimension(150, (int)dimension.getHeight());
        this.cp.setMaximumSize(dimension);
        this.cp.setPreferredSize(dimension);
    }

    public JembossComboPopup getComboPopup() {
        return this.cp;
    }

    public String getDefaultFormat() {
        return this.def;
    }

    public JCheckBox getAccCheckBox() {
        return this.raccshow;
    }

    public JCheckBox getDesCheckBox() {
        return this.rdesshow;
    }

    public JCheckBox getUsaDesCheckBox() {
        return this.rusashow;
    }

    private static String[] getReportFormats() {
        return rpt;
    }

    public String getReportFormat() {
        String string = " -rformat " + this.cp.getSelectedItem();
        if (this.raccshow.isSelected()) {
            string = string.concat(" -raccshow ");
        }
        if (this.rdesshow.isSelected()) {
            string = string.concat(" -rdesshow ");
        }
        if (this.rusashow.isSelected()) {
            string = string.concat(" -rusashow ");
        }
        return string;
    }

    protected Box getReportCheckBox() {
        Box box = new Box(0);
        box.add(this.getAccCheckBox());
        box.add(new LabelTextBox("Accession number", "Displays the accession number in the report"));
        box.add(Box.createHorizontalStrut(20));
        box.add(this.getDesCheckBox());
        box.add(new LabelTextBox("Description", "Displays the sequence description in the report"));
        box.add(Box.createHorizontalStrut(20));
        box.add(this.getUsaDesCheckBox());
        box.add(new LabelTextBox("Full USA", "Displays the universal sequence address in the report"));
        box.add(Box.createHorizontalGlue());
        return box;
    }

    public static String getToolTip() {
        String string = PlafMacros.getLineSeparator();
        return "embl \t\t\t\t\t\t\t\t- EMBL feature table format." + string + "genbank \t- Genbank feature table format." + string + "gff \t\t\t\t\t\t\t\t\t\t\t\t- GFF feature table format." + string + "pir \t\t\t\t\t\t\t\t\t\t\t\t- PIR feature table format." + string + "swiss \t\t\t\t\t\t\t- SwissProt feature table format." + string + "listfile \t\t\t\t\t\t- writes out a list file with start and end" + "points of the motifs given" + string + "by '[start:end]' after the" + "sequence's full USA. This can be read by other EMBOSS" + string + "programs using '@' or 'list::' before the filename." + string + "dbmotif \t\t\t\t- DbMotif format." + string + "diffseq \t\t\t\t\t- Useful when reporting the results of two sequences" + string + "aligned, as in the program diffseq." + string + "excel \t\t\t\t\t\t\t\t- TAB-delimited table format for spread-sheets" + string + "feattable \t\t- FeatTable format. It is an EMBL feature table" + string + "table using only the tags in the report definition." + string + "motif \t\t\t\t\t\t\t\t- Motif format. Based on the original" + string + "output format of antigenic, helixturnhelix and sigcleave." + string + "regions \t\t\t- Regions format." + string + "seqtable \t\t- Simple table format that includes the feature sequence." + string + "simple \t\t\t\t\t- SRS simple format." + string + "srs \t\t\t\t\t\t\t\t\t\t\t- SRS format." + string + "table \t\t\t\t\t\t\t- Table format." + string + "tagseq \t\t\t\t-  Tagseq format. Features are marked up below the sequence.";
    }
}

