/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Font;
import java.net.URL;
import java.util.Vector;
import javax.swing.JComboBox;

public class MemoryComboBox
extends JComboBox {
    public static final int MAX_MEM_LEN = 30;
    private Vector order;

    public MemoryComboBox(Vector vector) {
        super(vector);
        this.setEditable(true);
        this.order = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            this.order.add(vector.get(i));
        }
        this.setFont(new Font(null, 0, 12));
    }

    public void addURL(Object object) {
        this.removeItem(object);
        this.insertItemAt(object, 0);
        this.setSelectedItem(object);
        if (this.getItemCount() > 30) {
            this.removeItemAt(this.getItemCount() - 1);
        }
        this.order.add(object);
    }

    public void setLastIndex(Object object) {
        if (this.order.contains(object)) {
            this.order.remove(object);
            this.order.trimToSize();
            this.order.add(object);
        }
    }

    protected boolean isBackPage() {
        int n = this.order.indexOf(this.getSelectedItem());
        return this.order.size() > 1 && n >= 1;
    }

    protected boolean isForwardPage() {
        int n = this.order.indexOf(this.getSelectedItem());
        return n < this.order.size() - 1;
    }

    public boolean isItem(Object object) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!object.equals(this.getItemAt(i))) continue;
            return true;
        }
        return false;
    }

    public int getIndexOf(Object object) {
        return this.order.indexOf(object);
    }

    public URL getURLAt(int n) {
        return (URL)this.order.get(n);
    }
}

