/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import org.broad.tribble.util.ParsingUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ParsingUtilsTest {
    @Test
    public void testSplit1() {
        String[] tokens = new String[10];
        String blankColumnLine = "a\tb\t\td";
        int nTokens = ParsingUtils.split(blankColumnLine, tokens, '\t');
        Assert.assertEquals((int)nTokens, (int)4);
        Assert.assertEquals((String)tokens[0], (String)"a");
        Assert.assertEquals((String)tokens[1], (String)"b");
        Assert.assertEquals((String)tokens[2], (String)"");
        Assert.assertEquals((String)tokens[3], (String)"d");
    }

    @Test
    public void testSplit2() {
        String[] tokens = new String[10];
        String blankColumnLine = "a\tb\t\td\t";
        int nTokens = ParsingUtils.split(blankColumnLine, tokens, '\t');
        Assert.assertEquals((int)nTokens, (int)5);
        Assert.assertEquals((String)tokens[0], (String)"a");
        Assert.assertEquals((String)tokens[1], (String)"b");
        Assert.assertEquals((String)tokens[2], (String)"");
        Assert.assertEquals((String)tokens[3], (String)"d");
        Assert.assertEquals((String)tokens[4], (String)"");
    }

    @Test
    public void testSplitWhitespace1() {
        String[] tokens = new String[10];
        String blankColumnLine = "a b\t\td";
        int nTokens = ParsingUtils.splitWhitespace(blankColumnLine, tokens);
        Assert.assertEquals((int)nTokens, (int)4);
        Assert.assertEquals((String)tokens[0], (String)"a");
        Assert.assertEquals((String)tokens[1], (String)"b");
        Assert.assertEquals((String)tokens[2], (String)"");
        Assert.assertEquals((String)tokens[3], (String)"d");
    }

    @Test
    public void testSplitWhitespace2() {
        String[] tokens = new String[10];
        String blankColumnLine = "a b\t\td\t";
        int nTokens = ParsingUtils.splitWhitespace(blankColumnLine, tokens);
        Assert.assertEquals((int)nTokens, (int)5);
        Assert.assertEquals((String)tokens[0], (String)"a");
        Assert.assertEquals((String)tokens[1], (String)"b");
        Assert.assertEquals((String)tokens[2], (String)"");
        Assert.assertEquals((String)tokens[3], (String)"d");
    }
}

