#!/util/bin/ruby
# ########################################################
# a ruby script to generate a fake 3.3 vcf file for testing
# 
# it generates records from 1 to 100,001 on contig 1 (which can be modified)
# 
# created 6/8/2010
# ########################################################
infile = File.open(ARGV[0], "w")

header = "##format=VCRv3.3\n##source=ArbitrarySource\n##FORMAT=DP,1,Integer,\"Read Depth (only filtered reads used for calling)\"\n##FORMAT=GQ,1,Integer,\"Genotype Quality\"\n##FORMAT=GT,1,String,\"Genotype\"\n##INFO=AB,1,Float,\"Allele Balance for hets (ref/(ref+alt))\"\n##INFO=AF,1,Float,\"Allele Frequency\"\n##INFO=DP,1,Integer,\"Total Depth\"\n##INFO=Dels,1,Float,\"Fraction of Reads Containing Spanning Deletions\"\n##reference=human_b36_both.fasta\n#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT\tNA00001\tNA00002\tNA00003\n" 

rec = "\ttestid1\tG\tA\t12.22\t0\tAF=0.50;AlleleBalance=0.57;DoC=23;HomopolymerRun=0;MAPQ0=8;NS=1;RMSMAPQ=46.31;SB=-24.92;SpanningDeletions=0\tGT:DP:GQ\t1/0:23:19.27\t./.\t./.\n"    

infile.print "#{header}"     

# change the 100,000 below to modify record count, and the 1 at the beginning of the print to change the contig                            
100000.times { |x|
  infile.print "1\t#{x+1}#{rec}"
}
