/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.util.ArrayList;
import org.antlr.misc.IntervalSet;
import org.antlr.test.BaseTest;

public class TestIntervalSet
extends BaseTest {
    public void testSingleElement() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(99);
        String string = "99";
        TestIntervalSet.assertEquals((String)intervalSet.toString(), (String)string);
    }

    public void testIsolatedElements() throws Exception {
        IntervalSet intervalSet = new IntervalSet();
        intervalSet.add(1);
        intervalSet.add(122);
        intervalSet.add(65520);
        String string = "{1, 122, 65520}";
        TestIntervalSet.assertEquals((String)intervalSet.toString(), (String)string);
    }

    public void testMixedRangesAndElements() throws Exception {
        IntervalSet intervalSet = new IntervalSet();
        intervalSet.add(1);
        intervalSet.add(97, 122);
        intervalSet.add(48, 57);
        String string = "{1, 48..57, 97..122}";
        TestIntervalSet.assertEquals((String)intervalSet.toString(), (String)string);
    }

    public void testSimpleAnd() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(10, 20);
        IntervalSet intervalSet2 = IntervalSet.of(13, 15);
        String string = "13..15";
        String string2 = ((Object)intervalSet.and(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testRangeAndIsolatedElement() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(97, 122);
        IntervalSet intervalSet2 = IntervalSet.of(100);
        String string = "100";
        String string2 = ((Object)intervalSet.and(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testEmptyIntersection() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(97, 122);
        IntervalSet intervalSet2 = IntervalSet.of(48, 57);
        String string = "{}";
        String string2 = ((Object)intervalSet.and(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testEmptyIntersectionSingleElements() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(97);
        IntervalSet intervalSet2 = IntervalSet.of(100);
        String string = "{}";
        String string2 = ((Object)intervalSet.and(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testNotSingleElement() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(1, 1000);
        intervalSet.add(2000, 3000);
        IntervalSet intervalSet2 = IntervalSet.of(50, 50);
        String string = "{1..49, 51..1000, 2000..3000}";
        String string2 = ((Object)intervalSet2.complement(intervalSet)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testNotSet() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(1, 1000);
        IntervalSet intervalSet2 = IntervalSet.of(50, 60);
        intervalSet2.add(5);
        intervalSet2.add(250, 300);
        String string = "{1..4, 6..49, 61..249, 301..1000}";
        String string2 = ((Object)intervalSet2.complement(intervalSet)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testNotEqualSet() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(1, 1000);
        IntervalSet intervalSet2 = IntervalSet.of(1, 1000);
        String string = "{}";
        String string2 = ((Object)intervalSet2.complement(intervalSet)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testNotSetEdgeElement() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(1, 2);
        IntervalSet intervalSet2 = IntervalSet.of(1);
        String string = "2";
        String string2 = ((Object)intervalSet2.complement(intervalSet)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testNotSetFragmentedVocabulary() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(1, 255);
        intervalSet.add(1000, 2000);
        intervalSet.add(9999);
        IntervalSet intervalSet2 = IntervalSet.of(50, 60);
        intervalSet2.add(3);
        intervalSet2.add(250, 300);
        intervalSet2.add(10000);
        String string = "{1..2, 4..49, 61..249, 1000..2000, 9999}";
        String string2 = ((Object)intervalSet2.complement(intervalSet)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testSubtractOfCompletelyContainedRange() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(10, 20);
        IntervalSet intervalSet2 = IntervalSet.of(12, 15);
        String string = "{10..11, 16..20}";
        String string2 = ((Object)intervalSet.subtract(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testSubtractOfOverlappingRangeFromLeft() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(10, 20);
        IntervalSet intervalSet2 = IntervalSet.of(5, 11);
        String string = "12..20";
        String string2 = ((Object)intervalSet.subtract(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
        IntervalSet intervalSet3 = IntervalSet.of(5, 10);
        string = "11..20";
        string2 = ((Object)intervalSet.subtract(intervalSet3)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testSubtractOfOverlappingRangeFromRight() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(10, 20);
        IntervalSet intervalSet2 = IntervalSet.of(15, 25);
        String string = "10..14";
        String string2 = ((Object)intervalSet.subtract(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
        IntervalSet intervalSet3 = IntervalSet.of(20, 25);
        string = "10..19";
        string2 = ((Object)intervalSet.subtract(intervalSet3)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testSubtractOfCompletelyCoveredRange() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(10, 20);
        IntervalSet intervalSet2 = IntervalSet.of(1, 25);
        String string = "{}";
        String string2 = ((Object)intervalSet.subtract(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testSubtractOfRangeSpanningMultipleRanges() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(10, 20);
        intervalSet.add(30, 40);
        intervalSet.add(50, 60);
        IntervalSet intervalSet2 = IntervalSet.of(5, 55);
        String string = "56..60";
        String string2 = ((Object)intervalSet.subtract(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
        IntervalSet intervalSet3 = IntervalSet.of(15, 55);
        string = "{10..14, 56..60}";
        string2 = ((Object)intervalSet.subtract(intervalSet3)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testSubtractOfWackyRange() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(0, 113);
        intervalSet.add(115, 200);
        IntervalSet intervalSet2 = IntervalSet.of(0, 115);
        intervalSet2.add(117, 200);
        String string = "116";
        String string2 = ((Object)intervalSet.subtract(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testSimpleEquals() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(10, 20);
        IntervalSet intervalSet2 = IntervalSet.of(10, 20);
        Boolean bl = new Boolean(true);
        Boolean bl2 = new Boolean(intervalSet.equals(intervalSet2));
        TestIntervalSet.assertEquals((Object)bl2, (Object)bl);
        IntervalSet intervalSet3 = IntervalSet.of(15, 55);
        bl = new Boolean(false);
        bl2 = new Boolean(intervalSet.equals(intervalSet3));
        TestIntervalSet.assertEquals((Object)bl2, (Object)bl);
    }

    public void testEquals() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(10, 20);
        intervalSet.add(2);
        intervalSet.add(499, 501);
        IntervalSet intervalSet2 = IntervalSet.of(10, 20);
        intervalSet2.add(2);
        intervalSet2.add(499, 501);
        Boolean bl = new Boolean(true);
        Boolean bl2 = new Boolean(intervalSet.equals(intervalSet2));
        TestIntervalSet.assertEquals((Object)bl2, (Object)bl);
        IntervalSet intervalSet3 = IntervalSet.of(10, 20);
        intervalSet3.add(2);
        bl = new Boolean(false);
        bl2 = new Boolean(intervalSet.equals(intervalSet3));
        TestIntervalSet.assertEquals((Object)bl2, (Object)bl);
    }

    public void testSingleElementMinusDisjointSet() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(15, 15);
        IntervalSet intervalSet2 = IntervalSet.of(1, 5);
        intervalSet2.add(10, 20);
        String string = "{}";
        String string2 = ((Object)intervalSet.subtract(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testMembership() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(15, 15);
        intervalSet.add(50, 60);
        TestIntervalSet.assertTrue((!intervalSet.member(0) ? 1 : 0) != 0);
        TestIntervalSet.assertTrue((!intervalSet.member(20) ? 1 : 0) != 0);
        TestIntervalSet.assertTrue((!intervalSet.member(100) ? 1 : 0) != 0);
        TestIntervalSet.assertTrue((boolean)intervalSet.member(15));
        TestIntervalSet.assertTrue((boolean)intervalSet.member(55));
        TestIntervalSet.assertTrue((boolean)intervalSet.member(50));
        TestIntervalSet.assertTrue((boolean)intervalSet.member(60));
    }

    public void testIntersectionWithTwoContainedElements() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(10, 20);
        IntervalSet intervalSet2 = IntervalSet.of(2, 2);
        intervalSet2.add(15);
        intervalSet2.add(18);
        String string = "{15, 18}";
        String string2 = ((Object)intervalSet.and(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testIntersectionWithTwoContainedElementsReversed() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(10, 20);
        IntervalSet intervalSet2 = IntervalSet.of(2, 2);
        intervalSet2.add(15);
        intervalSet2.add(18);
        String string = "{15, 18}";
        String string2 = ((Object)intervalSet2.and(intervalSet)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testComplement() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(100, 100);
        intervalSet.add(101, 101);
        IntervalSet intervalSet2 = IntervalSet.of(100, 102);
        String string = "102";
        String string2 = ((Object)intervalSet.complement(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testComplement2() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(100, 101);
        IntervalSet intervalSet2 = IntervalSet.of(100, 102);
        String string = "102";
        String string2 = ((Object)intervalSet.complement(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testComplement3() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(1, 96);
        intervalSet.add(99, 65534);
        String string = "97..98";
        String string2 = ((Object)intervalSet.complement(1, 65534)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testMergeOfRangesAndSingleValues() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(0, 41);
        intervalSet.add(42);
        intervalSet.add(43, 65534);
        String string = "0..65534";
        String string2 = intervalSet.toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testMergeOfRangesAndSingleValuesReverse() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(43, 65534);
        intervalSet.add(42);
        intervalSet.add(0, 41);
        String string = "0..65534";
        String string2 = intervalSet.toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testMergeWhereAdditionMergesTwoExistingIntervals() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(42);
        intervalSet.add(10);
        intervalSet.add(0, 9);
        intervalSet.add(43, 65534);
        intervalSet.add(11, 41);
        String string = "0..65534";
        String string2 = intervalSet.toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testMergeWithDoubleOverlap() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(1, 10);
        intervalSet.add(20, 30);
        intervalSet.add(5, 25);
        String string = "1..30";
        String string2 = intervalSet.toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testSize() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(20, 30);
        intervalSet.add(50, 55);
        intervalSet.add(5, 19);
        String string = "32";
        String string2 = String.valueOf(intervalSet.size());
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testToList() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(20, 25);
        intervalSet.add(50, 55);
        intervalSet.add(5, 5);
        String string = "[5, 20, 21, 22, 23, 24, 25, 50, 51, 52, 53, 54, 55]";
        ArrayList arrayList = new ArrayList();
        String string2 = String.valueOf(intervalSet.toList());
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }

    public void testNotRIntersectionNotT() throws Exception {
        IntervalSet intervalSet = IntervalSet.of(0, 115);
        intervalSet.add(117, 200);
        IntervalSet intervalSet2 = IntervalSet.of(0, 113);
        intervalSet2.add(115, 200);
        String string = "{0..113, 115, 117..200}";
        String string2 = ((Object)intervalSet.and(intervalSet2)).toString();
        TestIntervalSet.assertEquals((String)string2, (String)string);
    }
}

