/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMException;
import net.sf.samtools.seekablestream.UserPasswordInput;
import net.sf.samtools.util.ftp.FTPClient;
import net.sf.samtools.util.ftp.FTPReply;

public class FTPUtils {
    static Map<String, String> userCredentials = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceAvailable(URL url) {
        InputStream is = null;
        try {
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            is = conn.getInputStream();
            boolean bl = is.read() >= 0;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new SAMException("Error closing connection", e);
                }
            }
        }
    }

    public static synchronized FTPClient connect(String host, String userInfo, UserPasswordInput userPasswordInput) throws IOException {
        FTPClient ftp = new FTPClient();
        FTPReply reply = ftp.connect(host);
        if (!reply.isSuccess()) {
            throw new RuntimeException("Could not connect to " + host);
        }
        String user = "anonymous";
        String password = "igv@broadinstitute.org";
        if (userInfo == null) {
            userInfo = userCredentials.get(host);
        }
        if (userInfo != null) {
            String[] tmp = userInfo.split(":");
            user = tmp[0];
            if (tmp.length > 1) {
                password = tmp[1];
            }
        }
        if (!(reply = ftp.login(user, password)).isSuccess()) {
            if (userPasswordInput == null) {
                throw new RuntimeException("Login failure for host: " + host);
            }
            userPasswordInput.setHost(host);
            boolean success = false;
            while (!success && userPasswordInput.showDialog()) {
                user = userPasswordInput.getUser();
                password = userPasswordInput.getPassword();
                reply = ftp.login(user, password);
                success = reply.isSuccess();
            }
            if (success) {
                userInfo = user + ":" + password;
                userCredentials.put(host, userInfo);
            } else {
                throw new RuntimeException("Login failure for host: " + host);
            }
        }
        if (!(reply = ftp.binary()).isSuccess()) {
            throw new RuntimeException("Could not set binary mode on host: " + host);
        }
        return ftp;
    }
}

