/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.PayloadMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.log4j.Logger;

public class ResultMessage
extends PayloadMessage {
    private static final Logger logger = Logger.getLogger(ResultMessage.class);
    private static final String KEY_STATE = "exitState";
    private static final String KEY_JOB_ID = "jobId";
    private static final String KEY_STATE_DETAIL = "stateDetail";
    private static final String KEY_ERROR_MESSAGE = "errorMessage";
    private static final String KEY_OUTPUT_TEXT = "outputText";
    private static final String KEY_SOURCE_CODE = "sourceCode";
    private String jobId;
    private JobState state;
    private String stateDetail;
    private String errorMessage;
    private String outputText;
    private String sourceCode;

    public ResultMessage(String jobId, JobState state, String stateDetail, String errorMessage, String outputText, Destination replyTo) {
        super(null);
        super.setReplyTo(replyTo);
        this.jobId = jobId;
        this.state = state;
        this.stateDetail = stateDetail;
        this.errorMessage = errorMessage;
        this.outputText = outputText;
    }

    public ResultMessage() {
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        this.jobId = from.getString(KEY_JOB_ID);
        this.state = JobState.valueOf(from.getString(KEY_STATE));
        this.stateDetail = from.getString(KEY_STATE_DETAIL);
        this.errorMessage = from.getString(KEY_ERROR_MESSAGE);
        this.outputText = from.getString(KEY_OUTPUT_TEXT);
        this.sourceCode = from.getString(KEY_SOURCE_CODE);
    }

    @Override
    public void marshal(MapMessage mapMessage) throws JMSException {
        super.marshal(mapMessage);
        mapMessage.setString(KEY_JOB_ID, this.jobId);
        mapMessage.setString(KEY_STATE, this.state.name());
        mapMessage.setString(KEY_STATE_DETAIL, this.stateDetail);
        mapMessage.setString(KEY_ERROR_MESSAGE, this.errorMessage);
        mapMessage.setString(KEY_OUTPUT_TEXT, this.outputText);
        mapMessage.setString(KEY_SOURCE_CODE, this.sourceCode);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public JobState getState() {
        return this.state;
    }

    public void setState(JobState exitState) {
        this.state = exitState;
    }

    public String getOutputText() {
        return this.outputText;
    }

    public void setOutputText(String output) {
        this.outputText = output;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public String getStateDetail() {
        return this.stateDetail;
    }

    public void setStateDetail(String stateDetail) {
        this.stateDetail = stateDetail;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }
}

