/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.log4j.Logger;

public class MessageListenerWrapper
implements MessageListener {
    private static final Logger logger = Logger.getLogger(MessageListenerWrapper.class);
    private MessagingListener actualListener;

    public MessageListenerWrapper(MessagingListener listener) {
        this.actualListener = listener;
    }

    public void onMessage(Message msg) {
        try {
            String msgClass = msg.getStringProperty("class");
            logger.debug((Object)("message received, class is " + msgClass));
            MapMessage mapMessage = (MapMessage)msg;
            ChipsterMessage chipsterMessage = (ChipsterMessage)Class.forName(msgClass).newInstance();
            chipsterMessage.unmarshal(mapMessage);
            this.actualListener.onChipsterMessage(chipsterMessage);
        }
        catch (Exception e) {
            logger.error((Object)"Exception when handling a message.", (Throwable)e);
        }
    }
}

