/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class RepeatMaskerTrack
extends Track {
    private Color color;
    private Collection<RegionContent> regions = new TreeSet<RegionContent>();

    public RepeatMaskerTrack() {
        this.color = Color.lightGray;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.regions != null) {
            Iterator<RegionContent> iter = this.regions.iterator();
            RegionContent regionContent = null;
            while (iter.hasNext()) {
                regionContent = iter.next();
                if (!this.getView().requestIntersects(regionContent.region)) {
                    iter.remove();
                    continue;
                }
                BpCoord startBp = regionContent.region.start;
                BpCoord endBp = new BpCoord(regionContent.region.end.bp + 1L, regionContent.region.end.chr);
                long startX = this.getView().bpToTrack(startBp).intValue();
                long endX = this.getView().bpToTrack(endBp).intValue();
                drawables.add(new RectDrawable(new Rectangle((int)startX, 0, (int)(endX - startX), this.getHeight()), this.color, this.color));
            }
        }
        return drawables;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        this.regions.addAll(dataResult.getContents());
    }

    @Override
    public int getHeight() {
        return 5;
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.REGION);
    }

    @Override
    public String getName() {
        return "RepeatMaskerTrack";
    }
}

