/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.GeneTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.RepeatMaskerTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.RulerTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.StatusTitleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TranscriptTrack;
import java.awt.Color;
import java.util.LinkedList;

public class GeneTrackGroup
extends TrackGroup {
    protected TranscriptTrack transcript;
    protected Track geneOverview;
    protected Track gene;
    protected RepeatMaskerTrack repeatMasker;
    protected Track geneOverviewReversed;
    protected Track geneReversed;
    protected TranscriptTrack transcriptReversed;
    private StatusTitleTrack titleTrack = new StatusTitleTrack("Annotations", Color.black);

    public GeneTrackGroup(GBrowserView dataView, DataThread annotationDataSource, DataThread repeatDataSource, boolean isUserData) {
        super(dataView);
        this.titleTrack.setView(this.view);
        if (annotationDataSource != null) {
            this.transcript = new TranscriptTrack();
            this.transcript.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.transcript.setView(dataView);
            this.transcript.addDataThread(annotationDataSource);
            this.transcript.setStrand(Strand.FORWARD);
            this.gene = new GeneTrack(GBrowserConstants.COLOR_BLUE_BRIGHTER);
            this.gene.setViewLimits(GBrowserConstants.SWITCH_VIEWS_AT, 10000000L);
            this.gene.setView(dataView);
            this.gene.addDataThread(annotationDataSource);
            this.gene.setStrand(Strand.FORWARD);
            this.titleTrack.addDataThread(annotationDataSource);
        }
        if (repeatDataSource != null) {
            this.repeatMasker = new RepeatMaskerTrack();
            this.repeatMasker.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.repeatMasker.setView(dataView);
            this.repeatMasker.addDataThread(repeatDataSource);
            this.titleTrack.addDataThread(repeatDataSource);
        }
        if (annotationDataSource != null) {
            this.geneReversed = new GeneTrack(GBrowserConstants.COLOR_BLUE_BRIGHTER);
            this.geneReversed.setViewLimits(GBrowserConstants.SWITCH_VIEWS_AT, 10000000L);
            this.geneReversed.setView(dataView);
            this.geneReversed.addDataThread(annotationDataSource);
            this.geneReversed.setStrand(Strand.REVERSE);
            this.transcriptReversed = new TranscriptTrack();
            this.transcriptReversed.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.transcriptReversed.setView(dataView);
            this.transcriptReversed.addDataThread(annotationDataSource);
            this.transcriptReversed.setStrand(Strand.REVERSE);
        }
        this.adds(isUserData);
    }

    public void adds(boolean isUserData) {
        this.tracks = new LinkedList();
        if (!isUserData) {
            this.tracks.add(this.titleTrack);
        }
        if (this.transcript != null) {
            this.tracks.add(this.transcript);
            this.tracks.add(this.gene);
        }
        if (isUserData) {
            SeparatorTrack separator = new SeparatorTrack(Color.gray, 1);
            separator.setView(this.view);
            this.tracks.add(separator);
        } else {
            RulerTrack ruler = new RulerTrack();
            ruler.setView(this.view);
            this.tracks.add(ruler);
        }
        if (this.repeatMasker != null) {
            this.tracks.add(this.repeatMasker);
        }
        if (this.transcript != null) {
            this.tracks.add(this.geneReversed);
            this.tracks.add(this.transcriptReversed);
        }
    }

    @Override
    public String getName() {
        return "GeneTrackGroup";
    }

    @Override
    public void showOrHide(String name, boolean state) {
        super.showOrHide(name, state);
    }

    @Override
    public LayoutTool.LayoutMode getLayoutMode() {
        return LayoutTool.LayoutMode.FIXED;
    }

    @Override
    public int getHeight() {
        if (this.getView().getBpRegion().getLength() < 10000000L) {
            return 250;
        }
        return 40;
    }
}

