/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.GtfToFeatureConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Exon;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Gene;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneSet;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.PositionAndStringKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class GeneTrack
extends Track {
    private HashSet<Exon> exons = new HashSet();
    private List<Integer> occupiedSpace = new ArrayList<Integer>();
    private Color color;

    public GeneTrack(Color color) {
        this.color = color;
        this.layoutMode = this.defaultLayoutMode = LayoutTool.LayoutMode.FULL;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        this.occupiedSpace.clear();
        if (this.exons != null) {
            GeneSet geneSet = new GeneSet();
            geneSet.add(this.exons.iterator(), this.view.getRequestRegion().grow(GtfToFeatureConversion.MAX_INTRON_LENGTH * 2));
            TreeMap<PositionAndStringKey, Gene> sortedGenes = new TreeMap<PositionAndStringKey, Gene>();
            Iterator geneIter = geneSet.values().iterator();
            while (geneIter.hasNext()) {
                Gene gene = (Gene)geneIter.next();
                if (!this.getView().requestIntersects(gene.getRegion())) {
                    geneIter.remove();
                    continue;
                }
                PositionAndStringKey key = new PositionAndStringKey(gene.getRegion().start, gene.getId());
                sortedGenes.put(key, gene);
            }
            for (Gene gene : sortedGenes.values()) {
                if (!this.getView().getBpRegion().intersects(gene.getRegion())) continue;
                String name = null;
                name = gene.getName() != null ? gene.getName() : (gene.getId() != null ? gene.getId() : "n/a");
                this.createDrawable(gene.getRegion().start, gene.getRegion().end, 4, this.color, name, drawables);
            }
        }
        return drawables;
    }

    private void createDrawable(BpCoord startBp, BpCoord endBp, int height, Color c, String name, Collection<Drawable> drawables) {
        int i;
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp);
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        for (i = 0; this.occupiedSpace.size() > i && this.occupiedSpace.get(i) > rect.x + 1; ++i) {
        }
        int end = rect.x + rect.width;
        if (this.occupiedSpace.size() > i) {
            this.occupiedSpace.set(i, end);
        } else {
            this.occupiedSpace.add(end);
        }
        rect.y = (i + 1) * (height + 10);
        rect.height = height;
        drawables.add(new RectDrawable(rect, c, null));
        if (this.isNameVisible(rect)) {
            this.drawTextAboveRectangle(name, drawables, rect, 1);
        }
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        for (RegionContent content : dataResult.getContents()) {
            Exon exon;
            Object value = content.values.get((Object)DataType.VALUE);
            if (!(value instanceof Exon) || (exon = (Exon)value).getRegion().getStrand() != this.getStrand()) continue;
            this.exons.add(exon);
        }
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.VALUE);
    }

    @Override
    public int getMinHeight() {
        return 100;
    }
}

