/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BinarySearchIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.Index;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class LineToRegionConversion
extends DataThread {
    private Index index;
    private LineParser parser;

    public LineToRegionConversion(URL url, LineParser parser, GBrowser browser) throws FileNotFoundException, URISyntaxException {
        super(browser);
        this.parser = parser;
        try {
            RandomAccessLineDataSource dataSource = new RandomAccessLineDataSource(url);
            this.index = new BinarySearchIndex(dataSource, parser);
        }
        catch (UnsortedDataException e) {
            e.printStackTrace();
            this.index = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GBrowserException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void processDataRequest(DataRequest request) {
        if (this.index == null) {
            return;
        }
        long start = request.start.bp;
        long end = request.end.bp;
        int EXTRA = 1000000;
        start = Math.max(start - (long)EXTRA, 1L);
        Region requestRegion = new Region(start, end += (long)EXTRA, request.start.chr);
        TreeMap<IndexKey, String> lines = null;
        try {
            lines = this.index.getFileLines(new DataRequest(requestRegion, request.getRequestedContents(), request.getStatus()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GBrowserException e) {
            e.printStackTrace();
        }
        LinkedList<RegionContent> list = new LinkedList<RegionContent>();
        for (Map.Entry entry : lines.entrySet()) {
            String line = (String)entry.getValue();
            this.parser.setLine(line);
            Region region = this.parser.getRegion();
            IndexKey id = (IndexKey)entry.getKey();
            LinkedHashMap<DataType, Object> valueMap = new LinkedHashMap<DataType, Object>();
            valueMap.put(DataType.ID, id);
            valueMap.put(DataType.VALUE, line);
            RegionContent regionContent = new RegionContent(region, valueMap);
            list.add(regionContent);
        }
        super.createDataResult(new DataResult(request.getStatus(), list));
    }
}

